/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.TableNameSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.TableOption;
import org.springframework.lang.Nullable;

public abstract class TableOptionsSpecification<T extends TableOptionsSpecification<T>>
extends TableNameSpecification {
    private final Map<String, Object> options = new LinkedHashMap<String, Object>();

    protected TableOptionsSpecification(CqlIdentifier name) {
        super(name);
    }

    protected TableOptionsSpecification(@Nullable CqlIdentifier keyspace, CqlIdentifier name) {
        super(keyspace, name);
    }

    public T with(TableOption option) {
        return this.with(option.getName(), null, option.escapesValue(), option.quotesValue());
    }

    public T with(TableOption option, Object value) {
        option.checkValue(value);
        return this.with(option.getName(), value, option.escapesValue(), option.quotesValue());
    }

    public T with(String name, @Nullable Object value, boolean escape, boolean quote) {
        if (!(value instanceof Map)) {
            if (escape) {
                value = CqlStringUtils.escapeSingle(value);
            }
            if (quote) {
                value = CqlStringUtils.singleQuote(value);
            }
        }
        this.options.put(name, value);
        return (T)this;
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }
}

