/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.UUID;
import org.springframework.lang.Nullable;

public abstract class RowUtils {
    private RowUtils() {
    }

    @Nullable
    public static Object getRowValue(Row row, int index, @Nullable Class<?> requiredType) {
        Comparable<Boolean> value;
        if (requiredType == null) {
            return row.getObject(index);
        }
        if (String.class == requiredType) {
            return row.getString(index);
        }
        if (Boolean.TYPE == requiredType || Boolean.class == requiredType) {
            value = row.getBoolean(index);
        } else if (Byte.TYPE == requiredType || Byte.class == requiredType) {
            value = row.getByte(index);
        } else if (Short.TYPE == requiredType || Short.class == requiredType) {
            value = row.getShort(index);
        } else if (Integer.TYPE == requiredType || Integer.class == requiredType) {
            value = row.getInt(index);
        } else if (Long.TYPE == requiredType || Long.class == requiredType) {
            value = row.getLong(index);
        } else if (Float.TYPE == requiredType || Float.class == requiredType) {
            value = Float.valueOf(row.getFloat(index));
        } else if (Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType) {
            value = row.getDouble(index);
        } else {
            if (BigDecimal.class == requiredType) {
                return row.getBigDecimal(index);
            }
            if (LocalDate.class == requiredType) {
                return row.getLocalDate(index);
            }
            if (LocalTime.class == requiredType) {
                return row.getLocalTime(index);
            }
            if (Date.class == requiredType) {
                Instant instant = row.getInstant(index);
                return instant == null ? null : Date.from(instant);
            }
            if (Instant.class == requiredType) {
                return row.getInstant(index);
            }
            if (ByteBuffer.class == requiredType) {
                return row.getByteBuffer(index);
            }
            if (TupleValue.class == requiredType) {
                return row.getTupleValue(index);
            }
            if (UdtValue.class == requiredType) {
                return row.getUdtValue(index);
            }
            if (UUID.class == requiredType) {
                return row.getUuid(index);
            }
            return row.getObject(index);
        }
        return row.isNull(index) ? null : value;
    }
}

