/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import java.nio.ByteBuffer;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraPageRequest
extends PageRequest {
    @Nullable
    private final ByteBuffer pagingState;
    private final boolean nextAllowed;

    private CassandraPageRequest(int page, int size, Sort sort, @Nullable ByteBuffer pagingState, boolean nextAllowed) {
        super(page, size, sort);
        this.pagingState = pagingState;
        this.nextAllowed = nextAllowed;
    }

    public static CassandraPageRequest of(int page, int size) {
        Assert.isTrue((page == 0 ? 1 : 0) != 0, (String)"Cannot create a Cassandra page request for an indexed page other than the first page (0)");
        return CassandraPageRequest.of(page, size, Sort.unsorted());
    }

    public static CassandraPageRequest of(int page, int size, Sort sort) {
        Assert.isTrue((page == 0 ? 1 : 0) != 0, (String)"Cannot create a Cassandra page request for an indexed page other than the first page (0)");
        return new CassandraPageRequest(page, size, sort, null, false);
    }

    public static CassandraPageRequest of(int page, int size, Sort.Direction direction, String ... properties) {
        Assert.isTrue((page == 0 ? 1 : 0) != 0, (String)"Cannot create a Cassandra page request for an indexed page other than the first page (0)");
        return CassandraPageRequest.of(page, size, Sort.by((Sort.Direction)direction, (String[])properties));
    }

    public static CassandraPageRequest of(Pageable current, @Nullable ByteBuffer pagingState) {
        return new CassandraPageRequest(current.getPageNumber(), current.getPageSize(), current.getSort(), pagingState, pagingState != null);
    }

    public static CassandraPageRequest first(int size) {
        return CassandraPageRequest.of(0, size, Sort.unsorted());
    }

    public static CassandraPageRequest first(int size, Sort sort) {
        return new CassandraPageRequest(0, size, sort, null, false);
    }

    public static CassandraPageRequest first(int size, Sort.Direction direction, String ... properties) {
        return CassandraPageRequest.first(size, Sort.by((Sort.Direction)direction, (String[])properties));
    }

    public static void validatePageable(Pageable pageable) {
        CassandraPageRequest pageRequest;
        if (pageable.isUnpaged() || pageable.getPageNumber() == 0) {
            return;
        }
        if (pageable instanceof CassandraPageRequest && (pageRequest = (CassandraPageRequest)pageable).getPagingState() != null) {
            return;
        }
        throw new IllegalArgumentException("Paging queries for pages other than the first one require a CassandraPageRequest with a valid paging state");
    }

    @Nullable
    public ByteBuffer getPagingState() {
        if (this.pagingState == null) {
            return null;
        }
        return this.pagingState.asReadOnlyBuffer();
    }

    public boolean hasNext() {
        return this.getPagingState() != null && this.nextAllowed;
    }

    public CassandraPageRequest next() {
        Assert.state((boolean)this.hasNext(), (String)"Cannot create a next page request without a PagingState");
        return new CassandraPageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSort(), this.getPagingState(), false);
    }

    public CassandraPageRequest withSort(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return new CassandraPageRequest(this.getPageNumber(), this.getPageSize(), sort, this.getPagingState(), this.nextAllowed);
    }

    public PageRequest previous() {
        Assert.state((this.getPageNumber() < 2 ? 1 : 0) != 0, (String)"Cannot navigate to an intermediate page");
        return super.previous();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CassandraPageRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CassandraPageRequest that = (CassandraPageRequest)((Object)obj);
        if (this.nextAllowed != that.nextAllowed) {
            return false;
        }
        return this.pagingState != null ? this.pagingState.equals(that.pagingState) : that.pagingState == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.pagingState != null ? this.pagingState.hashCode() : 0);
        result = 31 * result + (this.nextAllowed ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.format("Cassandra page request [number: %d, size %d, sort: %s, paging state: %s]", this.getPageNumber(), this.getPageSize(), this.getSort(), this.getPagingState());
    }
}

