/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlSession;
import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.cassandra.observability.CqlSessionObservationInterceptor;
import org.springframework.util.Assert;

public final class ObservableCqlSessionFactory {
    private ObservableCqlSessionFactory() {
        throw new UnsupportedOperationException("Can't instantiate a utility class");
    }

    public static CqlSession wrap(CqlSession session, ObservationRegistry observationRegistry) {
        return ObservableCqlSessionFactory.wrap(session, "Cassandra", observationRegistry);
    }

    public static CqlSession wrap(CqlSession session, String remoteServiceName, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)session, (String)"CqlSession must not be null");
        Assert.notNull((Object)remoteServiceName, (String)"CqlSessionObservationConvention must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget((Object)session);
        proxyFactory.addAdvice((Advice)new CqlSessionObservationInterceptor(session, remoteServiceName, observationRegistry));
        proxyFactory.addInterface(CqlSession.class);
        proxyFactory.addInterface(CqlSessionObservationInterceptor.ObservationDecoratedProxy.class);
        return (CqlSession)proxyFactory.getProxy();
    }
}

