/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import org.springframework.data.cassandra.core.convert.CassandraColumnType;
import org.springframework.data.cassandra.core.convert.DefaultCassandraColumnType;
import org.springframework.data.cassandra.core.convert.DefaultColumnType;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public interface ColumnType {
    public static ColumnType create(Class<?> type) {
        return ColumnType.create(TypeInformation.of(type));
    }

    public static ColumnType create(TypeInformation<?> type) {
        return new DefaultColumnType(type, new ColumnType[0]);
    }

    public static CassandraColumnType create(Class<?> type, DataType dataType) {
        return new DefaultCassandraColumnType(TypeInformation.of(type), dataType, new ColumnType[0]);
    }

    public static ColumnType listOf(ColumnType componentType) {
        if (componentType instanceof CassandraColumnType) {
            return ColumnType.listOf((CassandraColumnType)componentType);
        }
        return new DefaultColumnType(TypeInformation.LIST, componentType);
    }

    public static CassandraColumnType listOf(CassandraColumnType componentType) {
        return ColumnType.listOf(componentType, false);
    }

    public static CassandraColumnType listOf(CassandraColumnType componentType, boolean frozen) {
        return new DefaultCassandraColumnType(TypeInformation.LIST, () -> DataTypes.listOf((DataType)componentType.getDataType(), (boolean)frozen), componentType);
    }

    public static ColumnType setOf(ColumnType componentType) {
        if (componentType instanceof CassandraColumnType) {
            return ColumnType.setOf((CassandraColumnType)componentType);
        }
        return new DefaultColumnType(TypeInformation.SET, componentType);
    }

    public static CassandraColumnType setOf(CassandraColumnType componentType) {
        return ColumnType.setOf(componentType, false);
    }

    public static CassandraColumnType setOf(CassandraColumnType componentType, boolean frozen) {
        return new DefaultCassandraColumnType(TypeInformation.SET, () -> DataTypes.setOf((DataType)componentType.getDataType(), (boolean)frozen), componentType);
    }

    public static ColumnType mapOf(ColumnType keyType, ColumnType valueType) {
        return new DefaultColumnType(TypeInformation.MAP, keyType, valueType);
    }

    public static CassandraColumnType mapOf(CassandraColumnType keyType, CassandraColumnType valueType) {
        return ColumnType.mapOf(keyType, valueType, false);
    }

    public static CassandraColumnType mapOf(CassandraColumnType keyType, CassandraColumnType valueType, boolean frozen) {
        return new DefaultCassandraColumnType(TypeInformation.MAP, () -> DataTypes.mapOf((DataType)keyType.getDataType(), (DataType)valueType.getDataType(), (boolean)frozen), keyType, valueType);
    }

    public static CassandraColumnType udtOf(UserDefinedType dataType) {
        return new DefaultCassandraColumnType(UdtValue.class, (DataType)dataType, new ColumnType[0]);
    }

    public static CassandraColumnType tupleOf(TupleType dataType) {
        return new DefaultCassandraColumnType(TupleValue.class, (DataType)dataType, new ColumnType[0]);
    }

    public Class<?> getType();

    public boolean isCollectionLike();

    public boolean isList();

    public boolean isSet();

    public boolean isMap();

    @Nullable
    public ColumnType getComponentType();

    default public ColumnType getRequiredComponentType() {
        ColumnType columnType = this.getComponentType();
        if (columnType == null) {
            throw new IllegalStateException("Type has no component type");
        }
        return columnType;
    }

    @Nullable
    public ColumnType getMapValueType();

    default public ColumnType getRequiredMapValueType() {
        ColumnType columnType = this.getMapValueType();
        if (columnType == null) {
            throw new IllegalStateException("Type has no map value type");
        }
        return columnType;
    }
}

