/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.DefaultSpELExpressionEvaluator;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;

public class StringBasedCassandraQuery
extends AbstractCassandraQuery {
    private static final String COUNT_AND_EXISTS = "Manually defined query for %s cannot be a count and exists query at the same time!";
    private final StringBasedQuery stringBasedQuery;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final ExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public StringBasedCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public StringBasedCassandraQuery(String query2, CassandraQueryMethod method, CassandraOperations operations, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations);
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.stringBasedQuery = new StringBasedQuery(query2, method.getParameters(), expressionParser);
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation().orElse(null);
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            if (ProjectionUtil.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_AND_EXISTS, new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
        }
    }

    protected StringBasedQuery getStringBasedQuery() {
        return this.stringBasedQuery;
    }

    @Override
    public SimpleStatement createQuery(CassandraParameterAccessor parameterAccessor) {
        StringBasedQuery query2 = this.getStringBasedQuery();
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)this.getQueryMethod().getParameters(), parameterAccessor.getValues(), query2.getExpressionDependencies());
        return this.getQueryStatementCreator().select(query2, parameterAccessor, new DefaultSpELExpressionEvaluator(this.expressionParser, evaluationContext));
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    @Override
    protected boolean isModifyingQuery() {
        return false;
    }
}

