/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.domain.Slice;
import org.springframework.util.concurrent.ListenableFuture;

public interface AsyncCassandraOperations {
    public AsyncCqlOperations getAsyncCqlOperations();

    public CassandraConverter getConverter();

    public <T> ListenableFuture<List<T>> select(String var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<Void> select(String var1, Consumer<T> var2, Class<T> var3) throws DataAccessException;

    public <T> ListenableFuture<T> selectOne(String var1, Class<T> var2) throws DataAccessException;

    public ListenableFuture<AsyncResultSet> execute(Statement<?> var1) throws DataAccessException;

    public <T> ListenableFuture<List<T>> select(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<Slice<T>> slice(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<Void> select(Statement<?> var1, Consumer<T> var2, Class<T> var3) throws DataAccessException;

    public <T> ListenableFuture<T> selectOne(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<List<T>> select(Query var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<Slice<T>> slice(Query var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<Void> select(Query var1, Consumer<T> var2, Class<T> var3) throws DataAccessException;

    public <T> ListenableFuture<T> selectOne(Query var1, Class<T> var2) throws DataAccessException;

    public ListenableFuture<Boolean> update(Query var1, Update var2, Class<?> var3) throws DataAccessException;

    public ListenableFuture<Boolean> delete(Query var1, Class<?> var2) throws DataAccessException;

    public ListenableFuture<Long> count(Class<?> var1) throws DataAccessException;

    public ListenableFuture<Long> count(Query var1, Class<?> var2) throws DataAccessException;

    public ListenableFuture<Boolean> exists(Object var1, Class<?> var2) throws DataAccessException;

    public ListenableFuture<Boolean> exists(Query var1, Class<?> var2) throws DataAccessException;

    public <T> ListenableFuture<T> selectOneById(Object var1, Class<T> var2) throws DataAccessException;

    public <T> ListenableFuture<T> insert(T var1) throws DataAccessException;

    public <T> ListenableFuture<EntityWriteResult<T>> insert(T var1, InsertOptions var2) throws DataAccessException;

    public <T> ListenableFuture<T> update(T var1) throws DataAccessException;

    public <T> ListenableFuture<EntityWriteResult<T>> update(T var1, UpdateOptions var2) throws DataAccessException;

    public <T> ListenableFuture<T> delete(T var1) throws DataAccessException;

    public ListenableFuture<WriteResult> delete(Object var1, QueryOptions var2) throws DataAccessException;

    default public ListenableFuture<WriteResult> delete(Object entity, DeleteOptions options) throws DataAccessException {
        return this.delete(entity, (QueryOptions)options);
    }

    public ListenableFuture<Boolean> deleteById(Object var1, Class<?> var2) throws DataAccessException;

    public ListenableFuture<Void> truncate(Class<?> var1) throws DataAccessException;
}

