/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.vault.config.VaultReactiveHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.vault.core.ReactiveVaultOperations;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Flux.class})
@ConditionalOnBean(value={ReactiveVaultOperations.class})
class VaultReactiveHealthIndicatorConfiguration
extends CompositeReactiveHealthContributorConfiguration<VaultReactiveHealthIndicator, ReactiveVaultOperations> {
    private final Map<String, ReactiveVaultOperations> reactiveVaultTemplates;

    VaultReactiveHealthIndicatorConfiguration(Map<String, ReactiveVaultOperations> reactiveVaultTemplates) {
        this.reactiveVaultTemplates = reactiveVaultTemplates;
    }

    @Bean(name={"vaultHealthIndicator", "vaultReactiveHealthIndicator"})
    @ConditionalOnMissingBean(name={"vaultHealthIndicator"})
    ReactiveHealthContributor vaultHealthIndicator() {
        return (ReactiveHealthContributor)this.createContributor(this.reactiveVaultTemplates);
    }
}

