/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.partition;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.task.batch.partition.CommandLineArgsProvider;
import org.springframework.cloud.task.batch.partition.EnvironmentVariablesProvider;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class TaskLauncherHandler
implements Runnable {
    private CommandLineArgsProvider commandLineArgsProvider;
    private TaskRepository taskRepository;
    private boolean defaultArgsAsEnvironmentVars;
    private String stepName;
    private TaskExecution taskExecution;
    private EnvironmentVariablesProvider environmentVariablesProvider;
    private Resource resource;
    private Map<String, String> deploymentProperties;
    private TaskLauncher taskLauncher;
    private String applicationName;
    private StepExecution workerStepExecution;
    private Log logger = LogFactory.getLog(TaskLauncherHandler.class);

    public TaskLauncherHandler(CommandLineArgsProvider commandLineArgsProvider, TaskRepository taskRepository, boolean defaultArgsAsEnvironmentVars, String stepName, TaskExecution taskExecution, EnvironmentVariablesProvider environmentVariablesProvider, Resource resource, Map<String, String> deploymentProperties, TaskLauncher taskLauncher, String applicationName, StepExecution workerStepExecution) {
        this.commandLineArgsProvider = commandLineArgsProvider;
        this.taskRepository = taskRepository;
        this.defaultArgsAsEnvironmentVars = defaultArgsAsEnvironmentVars;
        this.stepName = stepName;
        this.taskExecution = taskExecution;
        this.environmentVariablesProvider = environmentVariablesProvider;
        this.resource = resource;
        this.deploymentProperties = deploymentProperties;
        this.taskLauncher = taskLauncher;
        this.applicationName = applicationName;
        this.workerStepExecution = workerStepExecution;
    }

    public TaskLauncherHandler(CommandLineArgsProvider commandLineArgsProvider, TaskRepository taskRepository, boolean defaultArgsAsEnvironmentVars, String stepName, TaskExecution taskExecution, EnvironmentVariablesProvider environmentVariablesProvider, Resource resource, Map<String, String> deploymentProperties, TaskLauncher taskLauncher, String applicationName) {
        this.commandLineArgsProvider = commandLineArgsProvider;
        this.taskRepository = taskRepository;
        this.defaultArgsAsEnvironmentVars = defaultArgsAsEnvironmentVars;
        this.stepName = stepName;
        this.taskExecution = taskExecution;
        this.environmentVariablesProvider = environmentVariablesProvider;
        this.resource = resource;
        this.deploymentProperties = deploymentProperties;
        this.taskLauncher = taskLauncher;
        this.applicationName = applicationName;
    }

    @Override
    public void run() {
        this.launchWorker(this.workerStepExecution);
    }

    public void launchWorker(StepExecution workerStepExecution) {
        ArrayList<String> arguments = new ArrayList<String>();
        ExecutionContext copyContext = new ExecutionContext(workerStepExecution.getExecutionContext());
        arguments.addAll(this.commandLineArgsProvider.getCommandLineArgs(copyContext));
        TaskExecution partitionTaskExecution = null;
        if (this.taskRepository != null) {
            partitionTaskExecution = this.taskRepository.createTaskExecution();
        } else {
            this.logger.warn((Object)"TaskRepository was not set so external execution id will not be recorded.");
        }
        if (!this.defaultArgsAsEnvironmentVars) {
            arguments.add(this.formatArgument("spring.cloud.task.job-execution-id", String.valueOf(workerStepExecution.getJobExecution().getId())));
            arguments.add(this.formatArgument("spring.cloud.task.step-execution-id", String.valueOf(workerStepExecution.getId())));
            arguments.add(this.formatArgument("spring.cloud.task.step-name", this.stepName));
            arguments.add(this.formatArgument("spring.cloud.task.name", String.format("%s_%s_%s", this.taskExecution.getTaskName(), workerStepExecution.getJobExecution().getJobInstance().getJobName(), workerStepExecution.getStepName())));
            arguments.add(this.formatArgument("spring.cloud.task.parentExecutionId", String.valueOf(this.taskExecution.getExecutionId())));
            if (partitionTaskExecution != null) {
                arguments.add(this.formatArgument("spring.cloud.task.executionid", String.valueOf(partitionTaskExecution.getExecutionId())));
            }
        }
        copyContext = new ExecutionContext(workerStepExecution.getExecutionContext());
        Map<String, String> environmentVariables = this.environmentVariablesProvider.getEnvironmentVariables(copyContext);
        if (this.defaultArgsAsEnvironmentVars) {
            environmentVariables.put("spring.cloud.task.job-execution-id", String.valueOf(workerStepExecution.getJobExecution().getId()));
            environmentVariables.put("spring.cloud.task.step-execution-id", String.valueOf(workerStepExecution.getId()));
            environmentVariables.put("spring.cloud.task.step-name", this.stepName);
            environmentVariables.put("spring.cloud.task.name", String.format("%s_%s_%s", this.taskExecution.getTaskName(), workerStepExecution.getJobExecution().getJobInstance().getJobName(), workerStepExecution.getStepName()));
            environmentVariables.put("spring.cloud.task.parentExecutionId", String.valueOf(this.taskExecution.getExecutionId()));
            environmentVariables.put("spring.cloud.task.executionid", String.valueOf(partitionTaskExecution.getExecutionId()));
        }
        AppDefinition definition = new AppDefinition(this.resolveApplicationName(), environmentVariables);
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.resource, this.deploymentProperties, arguments);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Requesting the launch of the following application: " + request));
        }
        String externalExecutionId = this.taskLauncher.launch(request);
        if (this.taskRepository != null) {
            this.taskRepository.updateExternalExecutionId(partitionTaskExecution.getExecutionId(), externalExecutionId);
        }
    }

    private String formatArgument(String key, String value) {
        return String.format("--%s=%s", key, value);
    }

    private String resolveApplicationName() {
        if (StringUtils.hasText((String)this.applicationName)) {
            return this.applicationName;
        }
        return this.taskExecution.getTaskName();
    }
}

