/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.stream.binder.BinderHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public final class StandardBatchUtils {
    private StandardBatchUtils() {
    }

    public static Iterable<Map.Entry<Object, Map<String, Object>>> iterate(final Message<List<Object>> batchMessage) {
        return () -> new Iterator<Map.Entry<Object, Map<String, Object>>>(){
            int index = 0;

            @Override
            public Map.Entry<Object, Map<String, Object>> next() {
                return StandardBatchUtils.getMessageByIndex((Message<List<Object>>)batchMessage, this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < ((List)batchMessage.getPayload()).size();
            }
        };
    }

    public static Map.Entry<Object, Map<String, Object>> getMessageByIndex(final Message<List<Object>> batchMessage, final int index) {
        Assert.isTrue((index < ((List)batchMessage.getPayload()).size() ? 1 : 0) != 0, (String)("Index " + index + " is out of bounds as there are only " + ((List)batchMessage.getPayload()).size() + " messages in a batch."));
        return new Map.Entry<Object, Map<String, Object>>(){

            @Override
            public Map<String, Object> setValue(Map<String, Object> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, Object> getValue() {
                return (Map)((List)batchMessage.getHeaders().get((Object)BinderHeaders.BATCH_HEADERS)).get(index);
            }

            @Override
            public Object getKey() {
                return ((List)batchMessage.getPayload()).get(index);
            }
        };
    }

    public static class BatchMessageBuilder {
        private final List<Object> payloads = new ArrayList<Object>();
        private final List<Map<String, Object>> batchHeaders = new ArrayList<Map<String, Object>>();
        private final Map<String, Object> headers = new HashMap<String, Object>();

        public BatchMessageBuilder addMessage(Object payload, Map<String, Object> batchHeaders) {
            this.payloads.add(payload);
            this.batchHeaders.add(batchHeaders);
            return this;
        }

        public BatchMessageBuilder addRootHeader(String key, Object value) {
            this.headers.put(key, value);
            return this;
        }

        public Message<List<Object>> build() {
            this.headers.put(BinderHeaders.BATCH_HEADERS, this.batchHeaders);
            return MessageBuilder.createMessage(this.payloads, (MessageHeaders)new MessageHeaders(this.headers));
        }
    }
}

