/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderTypeRegistry;
import org.springframework.cloud.stream.binding.CompositeMessageChannelConfigurer;
import org.springframework.cloud.stream.binding.FluxMessageChannelBindingTargetFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.binding.MessageSourceBindingTargetFactory;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.ContentTypeConfiguration;
import org.springframework.cloud.stream.config.SmartMessageMethodArgumentResolver;
import org.springframework.cloud.stream.config.SmartPayloadArgumentResolver;
import org.springframework.cloud.stream.function.StreamFunctionConfigurationProperties;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.integration.handler.support.MapArgumentResolver;
import org.springframework.integration.handler.support.PayloadExpressionArgumentResolver;
import org.springframework.integration.handler.support.PayloadsArgumentResolver;
import org.springframework.integration.support.NullAwarePayloadArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
@EnableConfigurationProperties(value={BindingServiceProperties.class})
@Import(value={ContentTypeConfiguration.class})
public class BinderFactoryAutoConfiguration {
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    private static final String SELF_CONTAINED_APP_PROPERTY_NAME = "spring.cloud.stream.internal.selfContained";
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Value(value="${spring.cloud.stream.internal.selfContained:}")
    private String selfContained;

    static Collection<BinderType> parseBinderConfigurations(ClassLoader classLoader, Resource resource) throws IOException, ClassNotFoundException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        ArrayList<BinderType> parsedBinderConfigurations = new ArrayList<BinderType>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String binderType = (String)entry.getKey();
            String[] binderConfigurationClassNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()));
            Class[] binderConfigurationClasses = new Class[binderConfigurationClassNames.length];
            int i = 0;
            for (String binderConfigurationClassName : binderConfigurationClassNames) {
                binderConfigurationClasses[i++] = ClassUtils.forName((String)binderConfigurationClassName, (ClassLoader)classLoader);
            }
            parsedBinderConfigurations.add(new BinderType(binderType, binderConfigurationClasses));
        }
        return parsedBinderConfigurations;
    }

    @Bean(value={"integrationMessageHandlerMethodFactory"})
    public static MessageHandlerMethodFactory messageHandlerMethodFactory(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, @Nullable Validator validator, ConfigurableListableBeanFactory clbf) {
        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        messageHandlerMethodFactory.setMessageConverter((MessageConverter)compositeMessageConverter);
        LinkedList<Object> resolvers = new LinkedList<Object>();
        resolvers.add((Object)new SmartPayloadArgumentResolver((MessageConverter)compositeMessageConverter, validator));
        resolvers.add((Object)new SmartMessageMethodArgumentResolver((MessageConverter)compositeMessageConverter));
        resolvers.add(new HeaderMethodArgumentResolver(clbf.getConversionService(), (ConfigurableBeanFactory)clbf));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new PayloadExpressionArgumentResolver());
        resolvers.add(new NullAwarePayloadArgumentResolver((MessageConverter)compositeMessageConverter));
        PayloadExpressionArgumentResolver payloadExpressionArgumentResolver = new PayloadExpressionArgumentResolver();
        payloadExpressionArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(payloadExpressionArgumentResolver);
        PayloadsArgumentResolver payloadsArgumentResolver = new PayloadsArgumentResolver();
        payloadsArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(payloadsArgumentResolver);
        MapArgumentResolver mapArgumentResolver = new MapArgumentResolver();
        mapArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(mapArgumentResolver);
        messageHandlerMethodFactory.setArgumentResolvers(resolvers);
        messageHandlerMethodFactory.setValidator(validator);
        return messageHandlerMethodFactory;
    }

    @Bean
    public BinderTypeRegistry binderTypeRegistry(ConfigurableApplicationContext configurableApplicationContext) {
        HashMap<String, BinderType> binderTypes = new HashMap<String, BinderType>();
        ClassLoader classLoader = configurableApplicationContext.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/spring.binders");
            if (!(!binderTypes.isEmpty() || Boolean.valueOf(this.selfContained).booleanValue() || resources != null && resources.hasMoreElements())) {
                this.logger.debug((Object)"Failed to locate 'META-INF/spring.binders' resources on the classpath. Assuming standard boot 'META-INF/spring.factories' configuration is used");
            } else {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    UrlResource resource = new UrlResource(url);
                    for (BinderType binderType : BinderFactoryAutoConfiguration.parseBinderConfigurations(classLoader, (Resource)resource)) {
                        binderTypes.put(binderType.getDefaultName(), binderType);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BeanCreationException("Cannot create binder factory:", (Throwable)e);
        }
        return new DefaultBinderTypeRegistry(binderTypes);
    }

    @Bean
    public StreamFunctionProperties streamFunctionProperties(@Nullable StreamFunctionConfigurationProperties properties) {
        StreamFunctionProperties streamFunctionProperties = new StreamFunctionProperties();
        if (properties != null) {
            streamFunctionProperties.setBindings(properties.getBindings());
        }
        return streamFunctionProperties;
    }

    @Bean
    public MessageConverterConfigurer messageConverterConfigurer(BindingServiceProperties bindingServiceProperties, @Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, @Nullable StreamFunctionProperties streamFunctionProperties) {
        return new MessageConverterConfigurer(bindingServiceProperties, compositeMessageConverter, streamFunctionProperties);
    }

    @Bean
    public SubscribableChannelBindingTargetFactory channelFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new SubscribableChannelBindingTargetFactory(compositeMessageChannelConfigurer);
    }

    @Bean
    public FluxMessageChannelBindingTargetFactory fluxMessageChannelBindingTargetFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer, GenericApplicationContext context) {
        return new FluxMessageChannelBindingTargetFactory(compositeMessageChannelConfigurer, context);
    }

    @Bean
    public MessageSourceBindingTargetFactory messageSourceFactory(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new MessageSourceBindingTargetFactory((SmartMessageConverter)compositeMessageConverter, compositeMessageChannelConfigurer);
    }

    @Bean
    public CompositeMessageChannelConfigurer compositeMessageChannelConfigurer(MessageConverterConfigurer messageConverterConfigurer) {
        ArrayList<MessageChannelConfigurer> configurerList = new ArrayList<MessageChannelConfigurer>();
        configurerList.add(messageConverterConfigurer);
        return new CompositeMessageChannelConfigurer(configurerList);
    }
}

