/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderCustomizer;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.reflection.GenericsUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.integration.channel.FluxMessageChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultBinderFactory
implements BinderFactory,
DisposableBean,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, BinderConfiguration> binderConfigurations;
    private final Map<String, Map.Entry<Binder<?, ?, ?>, ConfigurableApplicationContext>> binderInstanceCache = new HashMap();
    private final Map<String, String> defaultBinderForBindingTargetType = new HashMap<String, String>();
    private final Map<String, ApplicationContextInitializer<ConfigurableApplicationContext>> binderChildContextInitializers = new HashMap<String, ApplicationContextInitializer<ConfigurableApplicationContext>>();
    private final BinderTypeRegistry binderTypeRegistry;
    private final BinderCustomizer binderCustomizer;
    private volatile ConfigurableApplicationContext context;
    private Collection<Listener> listeners;
    private volatile String defaultBinder;

    public DefaultBinderFactory(Map<String, BinderConfiguration> binderConfigurations, BinderTypeRegistry binderTypeRegistry, BinderCustomizer binderCustomizer) {
        this.binderConfigurations = new HashMap<String, BinderConfiguration>(binderConfigurations);
        this.binderTypeRegistry = binderTypeRegistry;
        this.binderCustomizer = binderCustomizer;
    }

    void updateBinderConfigurations(Map<String, BinderConfiguration> binderConfigurations) {
        this.binderConfigurations.clear();
        this.binderConfigurations.putAll(binderConfigurations);
    }

    BinderTypeRegistry getBinderTypeRegistry() {
        return this.binderTypeRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public void setListeners(Collection<Listener> listeners) {
        this.listeners = listeners;
    }

    public void destroy() {
        this.binderInstanceCache.values().stream().map(Map.Entry::getValue).forEach(ConfigurableApplicationContext::close);
        this.defaultBinderForBindingTargetType.clear();
    }

    public synchronized <T> Binder<T, ?, ?> getBinder(String name, Class<? extends T> bindingTargetType) {
        Binder<? extends T, ConsumerProperties, ProducerProperties> binder;
        Map binders;
        String binderName = StringUtils.hasText((String)name) ? name : this.defaultBinder;
        Map map = binders = this.context == null ? Collections.emptyMap() : this.context.getBeansOfType(Binder.class);
        if (StringUtils.hasText((String)binderName) && binders.containsKey(binderName)) {
            binder = (Binder<? extends T, ConsumerProperties, ProducerProperties>)this.context.getBean(binderName);
        } else if (binders.size() == 1) {
            binder = (Binder)binders.values().iterator().next();
        } else {
            if (binders.size() > 1) {
                throw new IllegalStateException("Multiple binders are available, however neither default nor per-destination binder name is provided. Available binders are " + binders.keySet());
            }
            binder = this.doGetBinder(binderName, bindingTargetType);
        }
        if (this.binderCustomizer != null) {
            this.binderCustomizer.customize(binder, binderName);
        }
        return binder;
    }

    private <T> Binder<T, ConsumerProperties, ProducerProperties> doGetBinder(String name, Class<? extends T> bindingTargetType) {
        if (!CollectionUtils.isEmpty(this.binderChildContextInitializers)) {
            return this.doGetBinderAOT(name, bindingTargetType);
        }
        return this.doGetBinderConventional(name, bindingTargetType);
    }

    private <T> Binder<T, ConsumerProperties, ProducerProperties> doGetBinderAOT(String name, Class<? extends T> bindingTargetType) {
        if (!StringUtils.hasText((String)name) && !StringUtils.hasText((String)this.defaultBinder)) {
            boolean kafkaStreamsType = this.isKafkaStreamsType(bindingTargetType);
            if (this.binderChildContextInitializers.size() == 1 || kafkaStreamsType) {
                if (kafkaStreamsType) {
                    String kafkaStreamsBinderSimpleName = this.getKafkaStreamsBinderSimpleName(bindingTargetType);
                    return this.getBinderInstance(kafkaStreamsBinderSimpleName);
                }
                String configurationName = this.binderChildContextInitializers.keySet().iterator().next();
                this.logger.info((Object)("No specific name or default given - using single available child initializer '" + configurationName + "'"));
                return this.getBinderInstance(configurationName);
            }
            throw new IllegalStateException("No specific name or default given - can't determine which binder to use");
        }
        String configurationName = name;
        if (!StringUtils.hasText((String)configurationName)) {
            configurationName = this.defaultBinder;
        }
        if (this.binderChildContextInitializers.containsKey(configurationName)) {
            return this.getBinderInstance(configurationName);
        }
        throw new IllegalStateException("Requested binder '" + name + "' did not match available binders: " + this.binderChildContextInitializers.keySet());
    }

    private <T> String getKafkaStreamsBinderSimpleName(Class<? extends T> bindingTargetType) {
        return bindingTargetType.getSimpleName().toLowerCase();
    }

    private <T> boolean isKafkaStreamsType(Class<? extends T> bindingTargetType) {
        String className = bindingTargetType.getName();
        return className.contains("KStream") || className.contains("KTable");
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> Binder<T, ConsumerProperties, ProducerProperties> doGetBinderConventional(String name, Class<? extends T> bindingTargetType) {
        String configurationName;
        block11: {
            Iterator<Map.Entry<String, BinderConfiguration>> iterator;
            HashSet<String> defaultCandidateConfigurations;
            block10: {
                block8: {
                    block9: {
                        if (!MessageChannel.class.isAssignableFrom(bindingTargetType) && !PollableMessageSource.class.isAssignableFrom(bindingTargetType)) {
                            String bindingTargetTypeName = StringUtils.hasText((String)name) ? name : bindingTargetType.getSimpleName().toLowerCase();
                            return this.getBinderInstance(bindingTargetTypeName);
                        }
                        if (StringUtils.hasText((String)name)) break block8;
                        Assert.notEmpty(this.binderConfigurations, (String)"A default binder has been requested, but there is no binder available ");
                        if (StringUtils.hasText((String)this.defaultBinder)) break block9;
                        defaultCandidateConfigurations = new HashSet<String>();
                        iterator = this.binderConfigurations.entrySet().iterator();
                        break block10;
                    }
                    configurationName = this.defaultBinder;
                    break block11;
                }
                configurationName = name;
                break block11;
            }
            while (iterator.hasNext()) {
                Map.Entry<String, BinderConfiguration> binderConfigurationEntry = iterator.next();
                if ("integration".equals(binderConfigurationEntry.getKey())) {
                    defaultCandidateConfigurations.add(binderConfigurationEntry.getKey());
                    break;
                }
                if (!binderConfigurationEntry.getValue().isDefaultCandidate()) continue;
                defaultCandidateConfigurations.add((String)binderConfigurationEntry.getKey());
            }
            if (defaultCandidateConfigurations.size() == 1) {
                configurationName = (String)defaultCandidateConfigurations.iterator().next();
                this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
            } else {
                ArrayList<String> candidatesForBindableType = new ArrayList<String>();
                for (String defaultCandidateConfiguration : defaultCandidateConfigurations) {
                    Binder<T, ConsumerProperties, ProducerProperties> binderInstance = this.getBinderInstance(defaultCandidateConfiguration);
                    Class<T> binderType = GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0);
                    if (!binderType.isAssignableFrom(bindingTargetType)) continue;
                    this.populateCandidatesForBindableType(bindingTargetType, candidatesForBindableType, defaultCandidateConfiguration);
                }
                if (candidatesForBindableType.size() == 1) {
                    configurationName = (String)candidatesForBindableType.iterator().next();
                    this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                } else {
                    String countMsg = candidatesForBindableType.size() == 0 ? "are no binders" : "is more than one binder";
                    throw new IllegalStateException("A default binder has been requested, but there " + countMsg + " available for '" + bindingTargetType.getName() + "' : " + StringUtils.collectionToCommaDelimitedString(candidatesForBindableType) + ", and no default binder has been set.");
                }
            }
        }
        Binder<T, ConsumerProperties, ProducerProperties> binderInstance = this.getBinderInstance(configurationName);
        Assert.state((boolean)this.verifyBinderTypeMatchesTarget(binderInstance, bindingTargetType), (String)("The binder '" + configurationName + "' cannot bind a " + bindingTargetType.getName()));
        return binderInstance;
    }

    private <T> void populateCandidatesForBindableType(Class<? extends T> bindingTargetType, List<String> candidatesForBindableType, String defaultCandidateConfiguration) {
        boolean isCandidate;
        boolean bl = isCandidate = FluxMessageChannel.class.isAssignableFrom(bindingTargetType) && defaultCandidateConfiguration.startsWith("reactor") || !defaultCandidateConfiguration.startsWith("reactor");
        if (isCandidate) {
            candidatesForBindableType.add(defaultCandidateConfiguration);
        }
    }

    private <T> boolean verifyBinderTypeMatchesTarget(Binder<T, ?, ?> binderInstance, Class<? extends T> bindingTargetType) {
        return binderInstance instanceof PollableConsumerBinder && GenericsUtils.checkCompatiblePollableBinder(binderInstance, bindingTargetType) || GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0).isAssignableFrom(bindingTargetType);
    }

    private <T> Binder<T, ConsumerProperties, ProducerProperties> getBinderInstance(String configurationName) {
        if (!this.binderInstanceCache.containsKey(configurationName)) {
            FunctionCatalog functionCatalog;
            GenericApplicationContext binderProducingContext;
            this.logger.info((Object)("Creating binder: " + configurationName));
            BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
            HashMap<String, Object> binderProperties = new HashMap<String, Object>();
            if (this.binderChildContextInitializers.containsKey(configurationName)) {
                this.logger.info((Object)("Using AOT pre-prepared initializer to construct binder child context for " + configurationName));
                if (binderConfiguration != null) {
                    this.flatten(null, binderConfiguration.getProperties(), binderProperties);
                }
                binderProducingContext = this.createUnitializedContextForAOT(configurationName, binderProperties, binderConfiguration);
                this.binderChildContextInitializers.get(configurationName).initialize((ConfigurableApplicationContext)binderProducingContext);
                this.registerOuterContextBean(binderProperties, (ConfigurableApplicationContext)binderProducingContext);
                binderProducingContext.refresh();
            } else {
                this.logger.info((Object)("Constructing binder child context for " + configurationName));
                Assert.state((binderConfiguration != null ? 1 : 0) != 0, (String)("Unknown binder configuration: " + configurationName));
                this.flatten(null, binderConfiguration.getProperties(), binderProperties);
                BinderType binderType = this.binderTypeRegistry.get(binderConfiguration.getBinderType());
                Assert.notNull((Object)binderType, (String)("Binder type " + binderConfiguration.getBinderType() + " is not defined"));
                binderProducingContext = this.initializeBinderContextSimple(configurationName, binderProperties, binderType, binderConfiguration, true);
            }
            Map messageConverters = binderProducingContext.getBeansOfType(MessageConverter.class);
            if (!CollectionUtils.isEmpty((Map)messageConverters) && !ObjectUtils.isEmpty((Object)this.context.getBeansOfType(FunctionCatalog.class)) && (functionCatalog = (FunctionCatalog)this.context.getBean(FunctionCatalog.class)) instanceof SimpleFunctionRegistry) {
                SimpleFunctionRegistry simpleFunctionRegistry = (SimpleFunctionRegistry)functionCatalog;
                simpleFunctionRegistry.addMessageConverters(messageConverters.values());
            }
            Binder binder = (Binder)binderProducingContext.getBean(Binder.class);
            if (this.context != null && binder instanceof ApplicationContextAware) {
                ApplicationContextAware applicationContextAwareBinder = (ApplicationContextAware)binder;
                applicationContextAwareBinder.setApplicationContext((ApplicationContext)this.context);
            }
            if (!CollectionUtils.isEmpty(this.listeners)) {
                for (Listener binderFactoryListener : this.listeners) {
                    binderFactoryListener.afterBinderContextInitialized(configurationName, (ConfigurableApplicationContext)binderProducingContext);
                }
            }
            this.logger.info((Object)("Caching the binder: " + configurationName));
            this.binderInstanceCache.put(configurationName, new AbstractMap.SimpleImmutableEntry<Binder, GenericApplicationContext>(binder, binderProducingContext));
        }
        this.logger.trace((Object)("Retrieving cached binder: " + configurationName));
        return this.binderInstanceCache.get(configurationName).getKey();
    }

    Map<String, BinderConfiguration> getBinderConfigurations() {
        return this.binderConfigurations;
    }

    ConfigurableApplicationContext createBinderContextForAOT(String configurationName) {
        this.logger.info((Object)("Pre-creating binder child context (AOT) for " + configurationName));
        BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
        Assert.state((binderConfiguration != null ? 1 : 0) != 0, (String)("Unknown binder configuration: " + configurationName));
        BinderType binderType = this.binderTypeRegistry.get(binderConfiguration.getBinderType());
        Assert.notNull((Object)binderType, (String)("Binder type " + binderConfiguration.getBinderType() + " is not defined"));
        HashMap<String, Object> binderProperties = new HashMap<String, Object>();
        this.flatten(null, binderConfiguration.getProperties(), binderProperties);
        return this.initializeBinderContextSimple(configurationName, binderProperties, binderType, binderConfiguration, false);
    }

    void setBinderChildContextInitializers(Map<String, ApplicationContextInitializer<ConfigurableApplicationContext>> binderChildContextInitializers) {
        this.binderChildContextInitializers.clear();
        this.binderChildContextInitializers.putAll(binderChildContextInitializers);
    }

    ConfigurableApplicationContext initializeBinderContextSimple(String configurationName, Map<String, Object> binderProperties, BinderType binderType, BinderConfiguration binderConfiguration, boolean refresh) {
        ConfigurableEnvironment environment;
        String sources;
        AnnotationConfigApplicationContext binderProducingContext = new AnnotationConfigApplicationContext();
        if (this.context != null) {
            binderProducingContext.getBeanFactory().setConversionService(this.context.getBeanFactory().getConversionService());
        }
        ArrayList sourceClasses = new ArrayList();
        sourceClasses.addAll(Arrays.asList(binderType.getConfigurationClasses()));
        if (binderProperties.containsKey("spring.main.sources") && StringUtils.hasText((String)(sources = (String)binderProperties.get("spring.main.sources")))) {
            Stream.of(sources.split(",")).forEach(source -> {
                try {
                    sourceClasses.add(Thread.currentThread().getContextClassLoader().loadClass(source.trim()));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to load class " + source, e);
                }
            });
        }
        binderProducingContext.register(sourceClasses.toArray(new Class[0]));
        MapPropertySource binderPropertySource = new MapPropertySource(configurationName, binderProperties);
        binderProducingContext.getEnvironment().getPropertySources().addFirst((PropertySource)binderPropertySource);
        binderProducingContext.setDisplayName(configurationName + "_context");
        boolean useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
        ConfigurableEnvironment configurableEnvironment = environment = this.context != null ? this.context.getEnvironment() : null;
        if (useApplicationContextAsParent) {
            binderProducingContext.setParent((ApplicationContext)this.context);
        } else if (this.context != null) {
            binderProducingContext.addApplicationListener((ApplicationListener)new ApplicationListener<ApplicationEvent>(){

                public void onApplicationEvent(ApplicationEvent event) {
                    if (DefaultBinderFactory.this.context != null) {
                        try {
                            DefaultBinderFactory.this.context.publishEvent(event);
                        }
                        catch (Exception e) {
                            DefaultBinderFactory.this.logger.warn((Object)("Failed to publish " + event), (Throwable)e);
                        }
                    }
                }
            });
            if (environment != null && !useApplicationContextAsParent) {
                InitializerWithOuterContext initializer = new InitializerWithOuterContext((ApplicationContext)this.context);
                initializer.initialize((ConfigurableApplicationContext)binderProducingContext);
            }
            if (environment != null && (useApplicationContextAsParent || binderConfiguration.isInheritEnvironment())) {
                binderProducingContext.getEnvironment().merge(environment);
                binderProducingContext.getEnvironment().getPropertySources().remove("configurationProperties");
                binderProducingContext.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("defaultBinderFactoryProperties", Collections.singletonMap("spring.main.web-application-type", "NONE")));
            }
        }
        if (refresh) {
            binderProducingContext.refresh();
            if (!useApplicationContextAsParent || "integration".equals(binderType.getDefaultName())) {
                this.propagateSharedBeans((GenericApplicationContext)binderProducingContext, (GenericApplicationContext)this.context);
            }
        }
        return binderProducingContext;
    }

    private void propagateSharedBeans(GenericApplicationContext toContext, GenericApplicationContext fromContext) {
        if (toContext == null) {
            return;
        }
        GenericConversionService binderProducingConversionService = (GenericConversionService)toContext.getBeanFactory().getConversionService();
        try {
            Enumeration<URL> resources = ClassUtils.getDefaultClassLoader().getResources("META-INF/shared.beans");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                UrlResource resource = new UrlResource(url);
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                Set<Object> classNames = properties.keySet();
                for (Object className : classNames) {
                    Class<Object> beanType = this.loadClass(((String)className).trim());
                    if (beanType == null) continue;
                    Map beansOfType = fromContext.getBeansOfType(beanType);
                    beansOfType.entrySet().stream().forEach(entry -> {
                        Object bean = entry.getValue();
                        if (bean instanceof Converter) {
                            binderProducingConversionService.addConverter((Converter)bean);
                        } else {
                            toContext.registerBean((String)entry.getKey() + "_child", beanType, () -> entry.getValue(), new BeanDefinitionCustomizer[0]);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to propagate child beans. This may cause issues in your application", (Throwable)e);
        }
    }

    private Class<Object> loadClass(String className) {
        try {
            return ClassUtils.getDefaultClassLoader().loadClass(className.trim());
        }
        catch (Throwable e) {
            this.logger.debug((Object)("Attempt to load " + className + " failed."), e);
            return null;
        }
    }

    GenericApplicationContext createUnitializedContextForAOT(String configurationName, Map<String, Object> binderProperties, BinderConfiguration binderConfiguration) {
        ConfigurableEnvironment environment;
        GenericApplicationContext binderContext = new GenericApplicationContext();
        if (this.context != null) {
            binderContext.getBeanFactory().setConversionService(this.context.getBeanFactory().getConversionService());
        }
        MapPropertySource binderPropertySource = new MapPropertySource(configurationName, binderProperties);
        binderContext.getEnvironment().getPropertySources().addFirst((PropertySource)binderPropertySource);
        binderContext.setDisplayName(configurationName + "_context");
        boolean useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
        ConfigurableEnvironment configurableEnvironment = environment = this.context != null ? this.context.getEnvironment() : null;
        if (useApplicationContextAsParent) {
            binderContext.setParent((ApplicationContext)this.context);
        } else if (this.context != null) {
            binderContext.addApplicationListener(event -> {
                if (this.context != null) {
                    try {
                        this.context.publishEvent(event);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Failed to publish " + event), (Throwable)e);
                    }
                }
            });
            if (environment != null && (useApplicationContextAsParent || binderConfiguration.isInheritEnvironment())) {
                binderContext.getEnvironment().merge(environment);
                binderContext.getEnvironment().getPropertySources().remove("configurationProperties");
                binderContext.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("defaultBinderFactoryProperties", Collections.singletonMap("spring.main.web-application-type", "NONE")));
            }
        }
        return binderContext;
    }

    private void registerOuterContextBean(Map<String, Object> binderProperties, ConfigurableApplicationContext binderProducingContext) {
        boolean useApplicationContextAsParent;
        ConfigurableEnvironment environment = this.context != null ? this.context.getEnvironment() : null;
        boolean bl = useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
        if (environment != null && !useApplicationContextAsParent) {
            InitializerWithOuterContext initializer = new InitializerWithOuterContext((ApplicationContext)this.context);
            initializer.initialize(binderProducingContext);
        }
    }

    private void flatten(String propertyName, Object value, Map<String, Object> flattenedProperties) {
        if (value instanceof Map) {
            Map valueAsMap = (Map)value;
            valueAsMap.forEach((k, v) -> this.flatten((String)(propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    public static interface Listener {
        public void afterBinderContextInitialized(String var1, ConfigurableApplicationContext var2);
    }

    private static class InitializerWithOuterContext
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext context;

        InitializerWithOuterContext(ApplicationContext context) {
            this.context = context;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.getBeanFactory().registerSingleton("outerContext", (Object)this.context);
        }
    }
}

