/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
@ConditionalOnEnabledHealthIndicator(value="binders")
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@ConditionalOnBean(value={BinderFactory.class})
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class BindersHealthIndicatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public BindersHealthContributor bindersHealthContributor() {
        return new BindersHealthContributor();
    }

    @Bean
    public DefaultBinderFactory.Listener bindersHealthIndicatorListener(BindersHealthContributor bindersHealthContributor) {
        return new BindersHealthIndicatorListener(bindersHealthContributor);
    }

    private static class BindersHealthContributor
    implements CompositeHealthContributor {
        private static final HealthIndicator UNKNOWN = () -> Health.unknown().build();
        private Map<String, HealthContributor> contributors = new LinkedHashMap<String, HealthContributor>();

        private BindersHealthContributor() {
        }

        void add(String binderConfigurationName, Map<String, HealthContributor> binderHealthContributors) {
            this.contributors.put(binderConfigurationName, this.getContributor(binderHealthContributors));
        }

        private HealthContributor getContributor(Map<String, HealthContributor> binderHealthContributors) {
            if (binderHealthContributors.isEmpty()) {
                return UNKNOWN;
            }
            if (binderHealthContributors.size() == 1) {
                return binderHealthContributors.values().iterator().next();
            }
            return CompositeHealthContributor.fromMap(binderHealthContributors);
        }

        public HealthContributor getContributor(String name) {
            return this.contributors.get(name);
        }

        public Iterator<NamedContributor<HealthContributor>> iterator() {
            return this.contributors.entrySet().stream().map(entry -> NamedContributor.of((String)((String)entry.getKey()), entry.getValue())).iterator();
        }
    }

    private static class BindersHealthIndicatorListener
    implements DefaultBinderFactory.Listener {
        private final BindersHealthContributor bindersHealthContributor;

        BindersHealthIndicatorListener(BindersHealthContributor bindersHealthContributor) {
            this.bindersHealthContributor = bindersHealthContributor;
        }

        @Override
        public void afterBinderContextInitialized(String binderConfigurationName, ConfigurableApplicationContext binderContext) {
            if (this.bindersHealthContributor != null) {
                this.bindersHealthContributor.add(binderConfigurationName, binderContext.getBeansOfType(HealthContributor.class));
            }
        }
    }
}

