/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.lang.reflect.Method;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.binder.test.TestChannelBinder;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ReflectionUtils;

public class TestChannelBinderTests {
    @Test
    public void test() throws Exception {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder((Class[])TestChannelBinderConfiguration.getCompleteConfiguration(SampleConfiguration.class)).web(WebApplicationType.NONE).run(new String[]{"--spring.jmx.enabled=false", "--spring.cloud.stream.bindings.function-in-0.destination=input"});){
            TestChannelBinder binder = (TestChannelBinder)((Object)context.getBean(TestChannelBinder.class));
            Method registerErrorInfrastructure = ReflectionUtils.findMethod(TestChannelBinder.class, (String)"registerErrorInfrastructure", (Class[])new Class[]{ProducerDestination.class});
            registerErrorInfrastructure.setAccessible(true);
            Object destination = new ProducerDestination(){

                public String getNameForPartition(int partition) {
                    return "sample";
                }

                public String getName() {
                    return "sample";
                }
            };
            registerErrorInfrastructure.invoke((Object)binder, destination);
            destination = new ProducerDestination(){

                public String getNameForPartition(int partition) {
                    return "sample";
                }

                public String getName() {
                    return "sample";
                }
            };
            registerErrorInfrastructure.invoke((Object)binder, destination);
        }
    }

    @EnableAutoConfiguration
    public static class SampleConfiguration {
    }
}

