/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.binding.DispatchingStreamListenerMessageHandler;
import org.springframework.cloud.stream.binding.StreamListenerMessageHandler;
import org.springframework.cloud.stream.binding.StreamListenerMethodUtils;
import org.springframework.cloud.stream.binding.StreamListenerParameterAdapter;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.StreamListenerSetupMethodOrchestrator;
import org.springframework.cloud.stream.config.SpringIntegrationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StreamListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
SmartInitializingSingleton {
    private static final SpelExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    private final MultiValueMap<String, StreamListenerHandlerMethodMapping> mappedListenerMethods = new LinkedMultiValueMap();
    private final Set<Runnable> streamListenerCallbacks = new HashSet<Runnable>();
    private DestinationResolver<MessageChannel> binderAwareChannelResolver;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private SpringIntegrationProperties springIntegrationProperties;
    private ConfigurableApplicationContext applicationContext;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private Set<StreamListenerSetupMethodOrchestrator> streamListenerSetupMethodOrchestrators = new LinkedHashSet<StreamListenerSetupMethodOrchestrator>();

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        this.resolver = this.applicationContext.getBeanFactory().getBeanExpressionResolver();
        this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)this.applicationContext.getBeanFactory(), null);
    }

    public final void afterSingletonsInstantiated() {
        this.injectAndPostProcessDependencies();
        StandardEvaluationContext evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.applicationContext.getBeanFactory());
        for (Map.Entry mappedBindingEntry : this.mappedListenerMethods.entrySet()) {
            ArrayList<DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper> handlers = new ArrayList<DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper>();
            for (StreamListenerHandlerMethodMapping mapping : (List)mappedBindingEntry.getValue()) {
                InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(mapping.getTargetBean(), this.checkProxy(mapping.getMethod(), mapping.getTargetBean()));
                StreamListenerMessageHandler streamListenerMessageHandler = new StreamListenerMessageHandler(invocableHandlerMethod, this.resolveExpressionAsBoolean(mapping.getCopyHeaders(), "copyHeaders"), this.springIntegrationProperties.getMessageHandlerNotPropagatedHeaders());
                streamListenerMessageHandler.setApplicationContext((ApplicationContext)this.applicationContext);
                streamListenerMessageHandler.setBeanFactory((BeanFactory)this.applicationContext.getBeanFactory());
                if (StringUtils.hasText((String)mapping.getDefaultOutputChannel())) {
                    streamListenerMessageHandler.setOutputChannelName(mapping.getDefaultOutputChannel());
                }
                streamListenerMessageHandler.afterPropertiesSet();
                if (StringUtils.hasText((String)mapping.getCondition())) {
                    String conditionAsString = this.resolveExpressionAsString(mapping.getCondition(), "condition");
                    Expression condition = SPEL_EXPRESSION_PARSER.parseExpression(conditionAsString);
                    handlers.add(new DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper(condition, streamListenerMessageHandler));
                    continue;
                }
                handlers.add(new DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper(null, streamListenerMessageHandler));
            }
            if (handlers.size() > 1) {
                for (DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper handler : handlers) {
                    Assert.isTrue((boolean)handler.isVoid(), (String)"If multiple @StreamListener methods are listening to the same binding target, none of them may return a value");
                }
            }
            AbstractReplyProducingMessageHandler handler = handlers.size() > 1 || ((DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper)handlers.get(0)).getCondition() != null ? new DispatchingStreamListenerMessageHandler(handlers, (EvaluationContext)evaluationContext) : handlers.get(0).getStreamListenerMessageHandler();
            handler.setApplicationContext((ApplicationContext)this.applicationContext);
            handler.setChannelResolver(this.binderAwareChannelResolver);
            handler.afterPropertiesSet();
            this.applicationContext.getBeanFactory().registerSingleton(handler.getClass().getSimpleName() + handler.hashCode(), (Object)handler);
            ((SubscribableChannel)this.applicationContext.getBean((String)mappedBindingEntry.getKey(), SubscribableChannel.class)).subscribe((MessageHandler)handler);
        }
        this.mappedListenerMethods.clear();
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] uniqueDeclaredMethods;
        Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        for (Method method : uniqueDeclaredMethods = ReflectionUtils.getUniqueDeclaredMethods(targetClass)) {
            StreamListener streamListener = (StreamListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, StreamListener.class);
            if (streamListener == null || method.isBridge()) continue;
            this.streamListenerCallbacks.add(() -> {
                Assert.isTrue((method.getAnnotation(Input.class) == null ? 1 : 0) != 0, (String)"A method annotated with @StreamListener may never be annotated with @Input. If it should listen to a specific input, use the value of @StreamListener instead");
                this.doPostProcess(streamListener, method, bean);
            });
        }
        return bean;
    }

    protected StreamListener postProcessAnnotation(StreamListener originalAnnotation, Method annotatedMethod) {
        return originalAnnotation;
    }

    private void doPostProcess(StreamListener streamListener, Method method, Object bean) {
        streamListener = this.postProcessAnnotation(streamListener, method);
        Optional<StreamListenerSetupMethodOrchestrator> orchestratorOptional = this.streamListenerSetupMethodOrchestrators.stream().filter(t -> t.supports(method)).findFirst();
        Assert.isTrue((boolean)orchestratorOptional.isPresent(), (String)"A matching StreamListenerSetupMethodOrchestrator must be present");
        StreamListenerSetupMethodOrchestrator streamListenerSetupMethodOrchestrator = orchestratorOptional.get();
        streamListenerSetupMethodOrchestrator.orchestrateStreamListenerSetupMethod(streamListener, method, bean);
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@StreamListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    private String resolveExpressionAsString(String value, String property) {
        String resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return resolved;
        }
        throw new IllegalStateException("Resolved " + property + " to [" + resolved.getClass() + "] instead of String for [" + value + "]");
    }

    private boolean resolveExpressionAsBoolean(String value, String property) {
        String resolved = this.resolveExpression(value);
        if (resolved == null) {
            return false;
        }
        if (resolved instanceof String) {
            return Boolean.parseBoolean(resolved);
        }
        if (resolved instanceof Boolean) {
            return (Boolean)((Object)resolved);
        }
        throw new IllegalStateException("Resolved " + property + " to [" + resolved.getClass() + "] instead of String or Boolean for [" + value + "]");
    }

    private String resolveExpression(String value) {
        String resolvedValue = this.applicationContext.getBeanFactory().resolveEmbeddedValue(value);
        if (resolvedValue.startsWith("#{") && value.endsWith("}")) {
            resolvedValue = (String)this.resolver.evaluate(resolvedValue, this.expressionContext);
        }
        return resolvedValue;
    }

    private void injectAndPostProcessDependencies() {
        Collection streamListenerParameterAdapters = this.applicationContext.getBeansOfType(StreamListenerParameterAdapter.class).values();
        Collection streamListenerResultAdapters = this.applicationContext.getBeansOfType(StreamListenerResultAdapter.class).values();
        this.binderAwareChannelResolver = (DestinationResolver)this.applicationContext.getBean(DestinationResolver.class);
        this.messageHandlerMethodFactory = (MessageHandlerMethodFactory)this.applicationContext.getBean(MessageHandlerMethodFactory.class);
        this.springIntegrationProperties = (SpringIntegrationProperties)this.applicationContext.getBean(SpringIntegrationProperties.class);
        this.streamListenerSetupMethodOrchestrators.addAll(this.applicationContext.getBeansOfType(StreamListenerSetupMethodOrchestrator.class).values());
        this.streamListenerSetupMethodOrchestrators.add(new DefaultStreamListenerSetupMethodOrchestrator(this.applicationContext, streamListenerParameterAdapters, streamListenerResultAdapters));
        this.streamListenerCallbacks.forEach(Runnable::run);
    }

    private final class DefaultStreamListenerSetupMethodOrchestrator
    implements StreamListenerSetupMethodOrchestrator {
        private final ConfigurableApplicationContext applicationContext;
        private final Collection<StreamListenerParameterAdapter> streamListenerParameterAdapters;
        private final Collection<StreamListenerResultAdapter> streamListenerResultAdapters;

        private DefaultStreamListenerSetupMethodOrchestrator(ConfigurableApplicationContext applicationContext, Collection<StreamListenerParameterAdapter> streamListenerParameterAdapters, Collection<StreamListenerResultAdapter> streamListenerResultAdapters) {
            this.applicationContext = applicationContext;
            this.streamListenerParameterAdapters = streamListenerParameterAdapters;
            this.streamListenerResultAdapters = streamListenerResultAdapters;
        }

        @Override
        public void orchestrateStreamListenerSetupMethod(StreamListener streamListener, Method method, Object bean) {
            String methodAnnotatedInboundName = streamListener.value();
            String methodAnnotatedOutboundName = StreamListenerMethodUtils.getOutboundBindingTargetName(method);
            int inputAnnotationCount = StreamListenerMethodUtils.inputAnnotationCount(method);
            int outputAnnotationCount = StreamListenerMethodUtils.outputAnnotationCount(method);
            boolean isDeclarative = this.checkDeclarativeMethod(method, methodAnnotatedInboundName, methodAnnotatedOutboundName);
            StreamListenerMethodUtils.validateStreamListenerMethod(method, inputAnnotationCount, outputAnnotationCount, methodAnnotatedInboundName, methodAnnotatedOutboundName, isDeclarative, streamListener.condition());
            if (isDeclarative) {
                StreamListenerParameterAdapter[] toSlpaArray = new StreamListenerParameterAdapter[this.streamListenerParameterAdapters.size()];
                Object[] adaptedInboundArguments = this.adaptAndRetrieveInboundArguments(method, methodAnnotatedInboundName, (ApplicationContext)this.applicationContext, this.streamListenerParameterAdapters.toArray(toSlpaArray));
                this.invokeStreamListenerResultAdapter(method, bean, methodAnnotatedOutboundName, adaptedInboundArguments);
            } else {
                this.registerHandlerMethodOnListenedChannel(method, streamListener, bean);
            }
        }

        @Override
        public boolean supports(Method method) {
            return true;
        }

        private void invokeStreamListenerResultAdapter(Method method, Object bean, String outboundName, Object ... arguments) {
            block6: {
                try {
                    if (Void.TYPE.equals(method.getReturnType())) {
                        method.invoke(bean, arguments);
                        break block6;
                    }
                    Object result = method.invoke(bean, arguments);
                    if (!StringUtils.hasText((String)outboundName)) {
                        for (int parameterIndex = 0; parameterIndex < method.getParameterTypes().length; ++parameterIndex) {
                            MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
                            if (!methodParameter.hasParameterAnnotation(Output.class)) continue;
                            outboundName = ((Output)methodParameter.getParameterAnnotation(Output.class)).value();
                        }
                    }
                    Object targetBean = this.applicationContext.getBean(outboundName);
                    for (StreamListenerResultAdapter streamListenerResultAdapter : this.streamListenerResultAdapters) {
                        if (!streamListenerResultAdapter.supports(result.getClass(), targetBean.getClass())) continue;
                        streamListenerResultAdapter.adapt(result, targetBean);
                        break;
                    }
                }
                catch (Exception e) {
                    throw new BeanInitializationException("Cannot setup StreamListener for " + method, (Throwable)e);
                }
            }
        }

        private void registerHandlerMethodOnListenedChannel(Method method, StreamListener streamListener, Object bean) {
            Assert.hasText((String)streamListener.value(), (String)"The binding name cannot be null");
            if (!StringUtils.hasText((String)streamListener.value())) {
                throw new BeanInitializationException("A bound component name must be specified");
            }
            String defaultOutputChannel = StreamListenerMethodUtils.getOutboundBindingTargetName(method);
            if (Void.TYPE.equals(method.getReturnType())) {
                Assert.isTrue((boolean)StringUtils.isEmpty((Object)defaultOutputChannel), (String)"An output channel cannot be specified for a method that does not return a value");
            } else {
                Assert.isTrue((!StringUtils.isEmpty((Object)defaultOutputChannel) ? 1 : 0) != 0, (String)"An output channel must be specified for a method that can return a value");
            }
            StreamListenerMethodUtils.validateStreamListenerMessageHandler(method);
            StreamListenerAnnotationBeanPostProcessor.this.mappedListenerMethods.add((Object)streamListener.value(), (Object)new StreamListenerHandlerMethodMapping(bean, method, streamListener.condition(), defaultOutputChannel, streamListener.copyHeaders()));
        }

        private boolean checkDeclarativeMethod(Method method, String methodAnnotatedInboundName, String methodAnnotatedOutboundName) {
            int methodArgumentsLength = method.getParameterTypes().length;
            for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
                MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
                if (methodParameter.hasParameterAnnotation(Input.class)) {
                    String inboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
                    Assert.isTrue((boolean)StringUtils.hasText((String)inboundName), (String)"The @Input annotation must have the name of an input as value");
                    Assert.isTrue((boolean)this.isDeclarativeMethodParameter(inboundName, methodParameter), (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                    return true;
                }
                if (methodParameter.hasParameterAnnotation(Output.class)) {
                    String outboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                    Assert.isTrue((boolean)StringUtils.hasText((String)outboundName), (String)"The @Output annotation must have the name of an input as value");
                    Assert.isTrue((boolean)this.isDeclarativeMethodParameter(outboundName, methodParameter), (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                    return true;
                }
                if (StringUtils.hasText((String)methodAnnotatedOutboundName)) {
                    return this.isDeclarativeMethodParameter(methodAnnotatedOutboundName, methodParameter);
                }
                if (!StringUtils.hasText((String)methodAnnotatedInboundName)) continue;
                return this.isDeclarativeMethodParameter(methodAnnotatedInboundName, methodParameter);
            }
            return false;
        }

        private boolean isDeclarativeMethodParameter(String targetBeanName, MethodParameter methodParameter) {
            boolean declarative = false;
            if (!methodParameter.getParameterType().isAssignableFrom(Object.class) && this.applicationContext.containsBean(targetBeanName) && !(declarative = MessageChannel.class.isAssignableFrom(methodParameter.getParameterType()))) {
                Class targetBeanClass = this.applicationContext.getType(targetBeanName);
                declarative = this.streamListenerParameterAdapters.stream().anyMatch(slpa -> slpa.supports(targetBeanClass, methodParameter));
            }
            return declarative;
        }
    }

    private class StreamListenerHandlerMethodMapping {
        private final Object targetBean;
        private final Method method;
        private final String condition;
        private final String defaultOutputChannel;
        private final String copyHeaders;

        StreamListenerHandlerMethodMapping(Object targetBean, Method method, String condition, String defaultOutputChannel, String copyHeaders) {
            this.targetBean = targetBean;
            this.method = method;
            this.condition = condition;
            this.defaultOutputChannel = defaultOutputChannel;
            this.copyHeaders = copyHeaders;
        }

        Object getTargetBean() {
            return this.targetBean;
        }

        Method getMethod() {
            return this.method;
        }

        String getCondition() {
            return this.condition;
        }

        String getDefaultOutputChannel() {
            return this.defaultOutputChannel;
        }

        public String getCopyHeaders() {
            return this.copyHeaders;
        }
    }
}

