/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.DefaultHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
@ConditionalOnEnabledHealthIndicator(value="binders")
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@ConditionalOnBean(value={BinderFactory.class})
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
@Configuration
public class BindersHealthIndicatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"bindersHealthIndicator"})
    public CompositeHealthIndicator bindersHealthIndicator() {
        return new CompositeHealthIndicator((HealthAggregator)new OrderedHealthAggregator(), (HealthIndicatorRegistry)new DefaultHealthIndicatorRegistry());
    }

    @Bean
    public DefaultBinderFactory.Listener bindersHealthIndicatorListener(@Qualifier(value="bindersHealthIndicator") CompositeHealthIndicator compositeHealthIndicator) {
        return new BindersHealthIndicatorListener(compositeHealthIndicator);
    }

    private static class BindersHealthIndicatorListener
    implements DefaultBinderFactory.Listener {
        private final CompositeHealthIndicator bindersHealthIndicator;

        BindersHealthIndicatorListener(CompositeHealthIndicator bindersHealthIndicator) {
            this.bindersHealthIndicator = bindersHealthIndicator;
        }

        @Override
        public void afterBinderContextInitialized(String binderConfigurationName, ConfigurableApplicationContext binderContext) {
            if (this.bindersHealthIndicator != null) {
                OrderedHealthAggregator healthAggregator = new OrderedHealthAggregator();
                Map indicators = binderContext.getBeansOfType(HealthIndicator.class);
                DefaultHealthIndicator binderHealthIndicator = indicators.isEmpty() ? new DefaultHealthIndicator() : new CompositeHealthIndicator((HealthAggregator)healthAggregator, indicators);
                this.bindersHealthIndicator.getRegistry().register(binderConfigurationName, (HealthIndicator)binderHealthIndicator);
            }
        }

        private static class DefaultHealthIndicator
        extends AbstractHealthIndicator {
            private DefaultHealthIndicator() {
            }

            protected void doHealthCheck(Health.Builder builder) throws Exception {
                builder.unknown();
            }
        }
    }
}

