/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.reflect.ReflectData;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.stream.schema.ParsedSchema;
import org.springframework.cloud.stream.schema.SchemaNotFoundException;
import org.springframework.cloud.stream.schema.SchemaReference;
import org.springframework.cloud.stream.schema.SchemaRegistrationResponse;
import org.springframework.cloud.stream.schema.avro.AbstractAvroMessageConverter;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.core.io.Resource;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;

public class AvroSchemaRegistryClientMessageConverter
extends AbstractAvroMessageConverter
implements InitializingBean {
    public static final String AVRO_FORMAT = "avro";
    public static final Pattern PREFIX_VALIDATION_PATTERN = Pattern.compile("[\\p{Alnum}]");
    public static final String CACHE_PREFIX = "org.springframework.cloud.stream.schema";
    public static final String REFLECTION_CACHE_NAME = "org.springframework.cloud.stream.schema.reflectionCache";
    public static final String SCHEMA_CACHE_NAME = "org.springframework.cloud.stream.schema.schemaCache";
    public static final String REFERENCE_CACHE_NAME = "org.springframework.cloud.stream.schema.referenceCache";
    private Pattern versionedSchema;
    private boolean dynamicSchemaGenerationEnabled;
    private CacheManager cacheManager;
    private Schema readerSchema;
    private Resource[] schemaLocations;
    private SchemaRegistryClient schemaRegistryClient;
    private String prefix = "vnd";

    public AvroSchemaRegistryClientMessageConverter(SchemaRegistryClient schemaRegistryClient) {
        super(Arrays.asList(new MimeType("application", "*+avro")));
        Assert.notNull((Object)schemaRegistryClient, (String)"cannot be null");
        this.schemaRegistryClient = schemaRegistryClient;
    }

    public boolean isDynamicSchemaGenerationEnabled() {
        return this.dynamicSchemaGenerationEnabled;
    }

    public void setDynamicSchemaGenerationEnabled(boolean dynamicSchemaGenerationEnabled) {
        this.dynamicSchemaGenerationEnabled = dynamicSchemaGenerationEnabled;
    }

    public void setSchemaLocations(Resource[] schemaLocations) {
        Assert.notEmpty((Object[])schemaLocations, (String)"cannot be empty");
        this.schemaLocations = schemaLocations;
    }

    public void setPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"Prefix cannot be empty");
        Assert.isTrue((!PREFIX_VALIDATION_PATTERN.matcher(this.prefix).matches() ? 1 : 0) != 0, (String)("Invalid prefix:" + this.prefix));
        this.prefix = prefix;
    }

    public void afterPropertiesSet() throws Exception {
        this.versionedSchema = Pattern.compile("application/" + this.prefix + "\\.([\\p{Alnum}\\$\\.]+)\\.v(\\p{Digit}+)\\+avro");
        if (!ObjectUtils.isEmpty((Object[])this.schemaLocations)) {
            this.logger.info((Object)"Scanning avro schema resources on classpath");
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Parsing" + this.schemaLocations.length));
            }
            for (Resource schemaLocation : this.schemaLocations) {
                try {
                    Schema schema = AvroSchemaRegistryClientMessageConverter.parseSchema(schemaLocation);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Resource " + schemaLocation.getFilename() + " parsed into schema " + schema.getNamespace() + "." + schema.getName()));
                    }
                    this.schemaRegistryClient.register(this.toSubject(schema), AVRO_FORMAT, schema.toString(true));
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Schema " + schema.getName() + " registered with id " + schema));
                    }
                    this.cacheManager.getCache(REFLECTION_CACHE_NAME).put((Object)(schema.getNamespace() + "." + schema.getName()), (Object)schema);
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Failed to parse schema at " + schemaLocation.getFilename()), (Throwable)e);
                }
            }
        }
    }

    protected String toSubject(Schema schema) {
        return schema.getName().toLowerCase();
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean supportsMimeType(MessageHeaders headers) {
        if (super.supportsMimeType(headers)) {
            return true;
        }
        MimeType mimeType = this.getContentTypeResolver().resolve(headers);
        return MimeType.valueOf((String)"application/*+avro").includes(mimeType);
    }

    @Override
    protected Schema resolveSchemaForWriting(Object payload, MessageHeaders headers, MimeType hintedContentType) {
        Schema schema = this.extractSchemaForWriting(payload);
        ParsedSchema parsedSchema = (ParsedSchema)this.cacheManager.getCache(REFERENCE_CACHE_NAME).get((Object)schema, ParsedSchema.class);
        if (parsedSchema == null) {
            parsedSchema = new ParsedSchema(schema);
            this.cacheManager.getCache(REFERENCE_CACHE_NAME).putIfAbsent((Object)schema, (Object)parsedSchema);
        }
        if (parsedSchema.getRegistration() == null) {
            SchemaRegistrationResponse response = this.schemaRegistryClient.register(this.toSubject(schema), AVRO_FORMAT, parsedSchema.getRepresentation());
            parsedSchema.setRegistration(response);
        }
        SchemaReference schemaReference = parsedSchema.getRegistration().getSchemaReference();
        if (headers instanceof MutableMessageHeaders) {
            headers.put("contentType", (Object)("application/vnd." + schemaReference.getSubject() + ".v" + schemaReference.getVersion() + "+avro"));
        }
        return schema;
    }

    private SchemaReference extractSchemaReference(MimeType mimeType) {
        SchemaReference schemaReference = null;
        Matcher schemaMatcher = this.versionedSchema.matcher(mimeType.toString());
        if (schemaMatcher.find()) {
            String subject = schemaMatcher.group(1);
            Integer version = Integer.parseInt(schemaMatcher.group(2));
            schemaReference = new SchemaReference(subject, version, AVRO_FORMAT);
        }
        return schemaReference;
    }

    @Override
    protected Schema resolveWriterSchemaForDeserialization(MimeType mimeType) {
        if (this.readerSchema == null) {
            Schema schema = null;
            ParsedSchema parsedSchema = null;
            SchemaReference schemaReference = this.extractSchemaReference(mimeType);
            if (schemaReference != null && (parsedSchema = (ParsedSchema)this.cacheManager.getCache(REFERENCE_CACHE_NAME).get((Object)schemaReference, ParsedSchema.class)) == null) {
                String schemaContent = this.schemaRegistryClient.fetch(schemaReference);
                schema = new Schema.Parser().parse(schemaContent);
                parsedSchema = new ParsedSchema(schema);
                this.cacheManager.getCache(REFERENCE_CACHE_NAME).putIfAbsent((Object)schemaReference, (Object)parsedSchema);
            }
            return parsedSchema.getSchema();
        }
        return this.readerSchema;
    }

    @Override
    protected Schema resolveReaderSchemaForDeserialization(Class<?> targetClass) {
        return this.readerSchema;
    }

    public void setReaderSchema(Resource readerSchema) {
        Assert.notNull((Object)readerSchema, (String)"cannot be null");
        try {
            this.readerSchema = AvroSchemaRegistryClientMessageConverter.parseSchema(readerSchema);
        }
        catch (IOException e) {
            throw new BeanInitializationException("Cannot initialize reader schema", (Throwable)e);
        }
    }

    private Schema extractSchemaForWriting(Object payload) {
        Schema schema = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtaining schema for class " + payload.getClass()));
        }
        if (GenericContainer.class.isAssignableFrom(payload.getClass())) {
            schema = ((GenericContainer)payload).getSchema();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Avro type detected, using schema from object");
            }
        } else {
            schema = (Schema)this.cacheManager.getCache(REFLECTION_CACHE_NAME).get((Object)payload.getClass().getName(), Schema.class);
            if (schema == null) {
                if (!this.isDynamicSchemaGenerationEnabled()) {
                    throw new SchemaNotFoundException(String.format("No schema found in the local cache for %s, and dynamic schema generation is not enabled", payload.getClass()));
                }
                schema = ReflectData.get().getSchema(payload.getClass());
                this.cacheManager.getCache(REFLECTION_CACHE_NAME).put((Object)payload.getClass().getName(), (Object)schema);
            }
        }
        return schema;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

