/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.springframework.core.io.Resource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.MimeType;

public abstract class AbstractAvroMessageConverter
extends AbstractMessageConverter {
    protected AbstractAvroMessageConverter(MimeType supportedMimeType) {
        super(supportedMimeType);
    }

    protected AbstractAvroMessageConverter(Collection<MimeType> supportedMimeTypes) {
        super(supportedMimeTypes);
    }

    protected static Schema parseSchema(Resource r) throws IOException {
        return new Schema.Parser().parse(r.getInputStream());
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return super.canConvertFrom(message, targetClass) && message.getPayload() instanceof byte[];
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object result = null;
        try {
            byte[] payload = (byte[])message.getPayload();
            ByteBuffer buf = ByteBuffer.wrap(payload);
            MimeType mimeType = this.getContentTypeResolver().resolve(message.getHeaders());
            if (mimeType == null) {
                if (conversionHint instanceof MimeType) {
                    mimeType = (MimeType)conversionHint;
                } else {
                    return null;
                }
            }
            buf.get(payload);
            Schema writerSchema = this.resolveWriterSchemaForDeserialization(mimeType);
            Schema readerSchema = this.resolveReaderSchemaForDeserialization(targetClass);
            DatumReader<Object> reader = this.getDatumReader(targetClass, readerSchema, writerSchema);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(payload, null);
            result = reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new MessageConversionException(message, "Failed to read payload", (Throwable)e);
        }
        return result;
    }

    private DatumWriter<Object> getDatumWriter(Class<Object> type, Schema schema) {
        this.logger.debug((Object)("Finding correct DatumWriter for type " + type.getName()));
        Object writer = SpecificRecord.class.isAssignableFrom(type) ? (schema != null ? new SpecificDatumWriter(schema) : new SpecificDatumWriter(type)) : (GenericRecord.class.isAssignableFrom(type) ? new GenericDatumWriter(schema) : (schema != null ? new ReflectDatumWriter(schema) : new ReflectDatumWriter(type)));
        return writer;
    }

    protected DatumReader<Object> getDatumReader(Class<Object> type, Schema schema, Schema writerSchema) {
        SpecificDatumReader reader = null;
        if (SpecificRecord.class.isAssignableFrom(type)) {
            if (schema != null) {
                reader = writerSchema != null ? new SpecificDatumReader(writerSchema, schema) : new SpecificDatumReader(schema);
            } else {
                reader = new SpecificDatumReader(type);
                if (writerSchema != null) {
                    reader.setSchema(writerSchema);
                }
            }
        } else if (GenericRecord.class.isAssignableFrom(type)) {
            if (schema != null) {
                reader = writerSchema != null ? new GenericDatumReader(writerSchema, schema) : new GenericDatumReader(schema);
            }
        } else {
            reader = new ReflectDatumReader(type);
            if (writerSchema != null) {
                reader.setSchema(writerSchema);
            }
        }
        if (reader == null) {
            throw new MessageConversionException("No schema can be inferred from type " + type.getName() + " and no schema has been explicitly configured.");
        }
        return reader;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MimeType hintedContentType = null;
            if (conversionHint instanceof MimeType) {
                hintedContentType = (MimeType)conversionHint;
            }
            Schema schema = this.resolveSchemaForWriting(payload, headers, hintedContentType);
            DatumWriter<Object> writer = this.getDatumWriter(payload.getClass(), schema);
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
            writer.write(payload, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to write payload", (Throwable)e);
        }
        return baos.toByteArray();
    }

    protected abstract Schema resolveSchemaForWriting(Object var1, MessageHeaders var2, MimeType var3);

    protected abstract Schema resolveWriterSchemaForDeserialization(MimeType var1);

    protected abstract Schema resolveReaderSchemaForDeserialization(Class<?> var1);
}

