/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.registry.avro;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.util.MimeType;

class OriginalContentTypeResolver
implements ContentTypeResolver {
    private static final String BINDER_ORIGINAL_CONTENT_TYPE = "originalContentType";
    private ConcurrentMap<String, MimeType> mimeTypeCache = new ConcurrentHashMap<String, MimeType>();

    OriginalContentTypeResolver() {
    }

    public MimeType resolve(MessageHeaders headers) {
        Object contentType = headers.get((Object)BINDER_ORIGINAL_CONTENT_TYPE) != null ? headers.get((Object)BINDER_ORIGINAL_CONTENT_TYPE) : headers.get((Object)"contentType");
        MimeType mimeType = null;
        if (contentType instanceof MimeType) {
            MimeType mimeContentType;
            mimeType = mimeContentType = (MimeType)contentType;
        } else if (contentType instanceof String) {
            String valueAsString = (String)contentType;
            mimeType = (MimeType)this.mimeTypeCache.get(contentType);
            if (mimeType == null) {
                mimeType = MimeType.valueOf((String)valueAsString);
                this.mimeTypeCache.put(valueAsString, mimeType);
            }
        }
        return mimeType;
    }
}

