/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.registry.avro;

import java.lang.reflect.Constructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cloud.stream.schema.registry.avro.AvroMessageConverterProperties;
import org.springframework.cloud.stream.schema.registry.avro.AvroSchemaRegistryClientMessageConverter;
import org.springframework.cloud.stream.schema.registry.avro.AvroSchemaServiceManager;
import org.springframework.cloud.stream.schema.registry.avro.AvroSchemaServiceManagerImpl;
import org.springframework.cloud.stream.schema.registry.avro.SubjectNamingStrategy;
import org.springframework.cloud.stream.schema.registry.client.SchemaRegistryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.apache.avro.Schema"})
@ConditionalOnProperty(value={"spring.cloud.stream.schemaRegistryClient.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SchemaRegistryClient.class})
@EnableConfigurationProperties(value={AvroMessageConverterProperties.class})
@Import(value={AvroSchemaServiceManagerImpl.class})
public class AvroMessageConverterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AvroSchemaRegistryClientMessageConverter.class})
    public AvroSchemaRegistryClientMessageConverter avroSchemaMessageConverter1(SchemaRegistryClient schemaRegistryClient, AvroSchemaServiceManager avroSchemaServiceManager, AvroMessageConverterProperties avroMessageConverterProperties) {
        AvroSchemaRegistryClientMessageConverter avroSchemaRegistryClientMessageConverter = new AvroSchemaRegistryClientMessageConverter(schemaRegistryClient, this.cacheManager(), avroSchemaServiceManager);
        avroSchemaRegistryClientMessageConverter.setDynamicSchemaGenerationEnabled(avroMessageConverterProperties.isDynamicSchemaGenerationEnabled());
        if (avroMessageConverterProperties.getReaderSchema() != null) {
            avroSchemaRegistryClientMessageConverter.setReaderSchema(avroMessageConverterProperties.getReaderSchema());
        }
        if (!ObjectUtils.isEmpty((Object[])avroMessageConverterProperties.getSchemaLocations())) {
            avroSchemaRegistryClientMessageConverter.setSchemaLocations(avroMessageConverterProperties.getSchemaLocations());
        }
        if (!ObjectUtils.isEmpty((Object[])avroMessageConverterProperties.getSchemaImports())) {
            avroSchemaRegistryClientMessageConverter.setSchemaImports(avroMessageConverterProperties.getSchemaImports());
        }
        avroSchemaRegistryClientMessageConverter.setPrefix(avroMessageConverterProperties.getPrefix());
        if (avroMessageConverterProperties.isIgnoreSchemaRegistryServer()) {
            avroSchemaRegistryClientMessageConverter.setIgnoreSchemaRegistryServer(true);
        }
        try {
            Class<?> clazz = avroMessageConverterProperties.getSubjectNamingStrategy();
            Constructor constructor = ReflectionUtils.accessibleConstructor(clazz, (Class[])new Class[0]);
            avroSchemaRegistryClientMessageConverter.setSubjectNamingStrategy((SubjectNamingStrategy)constructor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create SubjectNamingStrategy " + avroMessageConverterProperties.getSubjectNamingStrategy().toString(), ex);
        }
        avroSchemaRegistryClientMessageConverter.setSubjectNamePrefix(avroMessageConverterProperties.getSubjectNamePrefix());
        return avroSchemaRegistryClientMessageConverter;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager();
    }
}

