/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.SocketPolicy;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public abstract class TraceRestTemplateInterceptorIntegrationTests
implements TestTracingAwareSupplier {
    public final MockWebServer mockWebServer = new MockWebServer();
    private RestTemplate template = new RestTemplate(this.clientHttpRequestFactory());
    Tracer tracer = this.tracerTest().tracing().tracer();
    TestSpanHandler spans = this.tracerTest().handler();

    @BeforeEach
    void before() throws IOException {
        this.mockWebServer.start();
    }

    @AfterEach
    void after() throws IOException {
        this.mockWebServer.close();
    }

    @BeforeEach
    public void setup() {
        this.template.setInterceptors(Arrays.asList(TracingClientHttpRequestInterceptor.create((CurrentTraceContext)this.tracerTest().tracing().currentTraceContext(), (HttpClientHandler)this.tracerTest().tracing().httpClientHandler())));
    }

    @AfterEach
    public void clean() {
        this.tracerTest().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void spanRemovedFromThreadUponException() throws IOException {
        this.mockWebServer.enqueue(new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_START));
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.template.getForEntity("http://localhost:" + this.mockWebServer.getPort() + "/exception", Map.class, new Object[0]).getBody();
            Assertions.fail((String)"should throw an exception");
        }
        catch (RuntimeException e) {
            BDDAssertions.then((Throwable)e).hasRootCauseInstanceOf(IOException.class);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(2);
        FinishedSpan span1 = this.spans.get(0);
        BDDAssertions.then((Throwable)span1.getError()).hasMessage("Read timed out");
        BDDAssertions.then((Comparable)span1.getKind()).isEqualTo((Object)Span.Kind.CLIENT);
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setReadTimeout(100);
        factory.setConnectTimeout(100);
        return factory;
    }
}

