/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.r2dbc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveCustomer;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveCustomerRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class ReactiveNestedTransactionService {
    private static final Logger log = LoggerFactory.getLogger(ReactiveNestedTransactionService.class);
    private final ReactiveCustomerRepository repository;

    public ReactiveNestedTransactionService(ReactiveCustomerRepository repository) {
        this.repository = repository;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Mono<Void> requiresNew() {
        return Mono.fromRunnable(() -> log.info("Hello from nested transaction")).then(this.repository.save(new ReactiveCustomer("Hello", "From Propagated Transaction"))).then();
    }
}

