/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.TraceJdbcAutoConfiguration;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategyTests;
import org.springframework.cloud.sleuth.test.TestSpanHandler;

public abstract class TraceJdbcEventListenerTests
extends TraceListenerStrategyTests {
    protected final ApplicationContextRunner contextRunner = (ApplicationContextRunner)((ApplicationContextRunner)((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{DataSourceAutoConfiguration.class, TraceJdbcAutoConfiguration.class, this.autoConfiguration(), PropertyPlaceholderAutoConfiguration.class}))).withUserConfiguration(new Class[]{this.testConfiguration()})).withPropertyValues(new String[]{"spring.datasource.initialization-mode=never", "spring.datasource.url=jdbc:h2:mem:testdb-baz", "spring.datasource.hikari.pool-name=test"})).withClassLoader((ClassLoader)new FilteredClassLoader(new String[]{"net.ttddyy.dsproxy"}));

    @Override
    ApplicationContextRunner parentContextRunner() {
        return this.contextRunner;
    }

    @Test
    void testShouldUsePlaceholderInSqlTagOfSpansForPreparedStatementIfIncludeParameterValuesIsSetToFalse() {
        this.contextRunner.run(context -> {
            DataSource dataSource = (DataSource)context.getBean(DataSource.class);
            TestSpanHandler spanReporter = (TestSpanHandler)context.getBean(TestSpanHandler.class);
            Connection connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE INFORMATION_SCHEMA.TABLES SET table_Name = ? WHERE 0 = ?");
            preparedStatement.setString(1, "");
            preparedStatement.setInt(2, 1);
            preparedStatement.executeUpdate();
            connection.close();
            Assertions.assertThat(spanReporter.reportedSpans()).hasSize(2);
            FinishedSpan connectionSpan = spanReporter.reportedSpans().get(1);
            FinishedSpan statementSpan = spanReporter.reportedSpans().get(0);
            Assertions.assertThat((String)connectionSpan.getName()).isEqualTo("connection");
            Assertions.assertThat((String)statementSpan.getName()).isEqualTo("update");
            Assertions.assertThat((Map)statementSpan.getTags()).containsEntry((Object)"jdbc.query", (Object)"UPDATE INFORMATION_SCHEMA.TABLES SET table_Name = ? WHERE 0 = ?");
            Assertions.assertThat((Map)statementSpan.getTags()).containsEntry((Object)"jdbc.row-count", (Object)"0");
        });
    }

    @Test
    void testShouldNotUsePlaceholderInSqlTagOfSpansForPreparedStatementIfIncludeParameterValuesIsSetToTrue() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"spring.sleuth.jdbc.p6spy.tracing.include-parameter-values=true"})).run(context -> {
            DataSource dataSource = (DataSource)context.getBean(DataSource.class);
            TestSpanHandler spanReporter = (TestSpanHandler)context.getBean(TestSpanHandler.class);
            Connection connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE INFORMATION_SCHEMA.TABLES SET table_Name = ? WHERE 0 = ?");
            preparedStatement.setString(1, "");
            preparedStatement.setInt(2, 1);
            preparedStatement.executeUpdate();
            connection.close();
            Assertions.assertThat(spanReporter.reportedSpans()).hasSize(2);
            FinishedSpan connectionSpan = spanReporter.reportedSpans().get(1);
            FinishedSpan statementSpan = spanReporter.reportedSpans().get(0);
            Assertions.assertThat((String)connectionSpan.getName()).isEqualTo("connection");
            Assertions.assertThat((String)statementSpan.getName()).isEqualTo("update");
            Assertions.assertThat((Map)statementSpan.getTags()).containsEntry((Object)"jdbc.query", (Object)"UPDATE INFORMATION_SCHEMA.TABLES SET table_Name = '' WHERE 0 = 1");
            Assertions.assertThat((Map)statementSpan.getTags()).containsEntry((Object)"jdbc.row-count", (Object)"0");
        });
    }
}

