/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import reactor.core.publisher.Mono;

@ContextConfiguration(classes={TestConfig.class})
public abstract class ReactiveCircuitBreakerIntegrationTests {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @Autowired
    ReactiveCircuitBreakerFactory factory;
    @Autowired
    CircuitService circuitService;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_pass_tracing_information_when_using_circuit_breaker() {
        Tracer tracer = this.tracer;
        ScopedSpan scopedSpan = null;
        try {
            scopedSpan = tracer.startScopedSpan("start");
            Span span = (Span)this.factory.create("name").run(Mono.defer(() -> Mono.just((Object)tracer.currentSpan()))).block();
            BDDAssertions.then((Object)span).isNotNull();
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(span.context().traceId());
        }
        finally {
            scopedSpan.end();
        }
    }

    @Test
    public void should_pass_tracing_information_when_using_circuit_breaker_with_fallback() {
        BDDAssertions.then((String)((String)this.circuitService.call().block())).isEqualTo("fallback");
        BDDAssertions.then((Iterable)this.spans).hasSize(2);
        String traceId = this.circuitService.firstSpan.context().traceId();
        BDDAssertions.then((String)this.circuitService.secondSpan.context().traceId()).isEqualTo(traceId);
        FinishedSpan finishedSpan = this.spans.get(0);
        BDDAssertions.then((String)finishedSpan.getName()).contains(new CharSequence[]{"CircuitBreakerIntegrationTests"});
        finishedSpan = this.spans.get(1);
        BDDAssertions.then((String)finishedSpan.getName()).contains(new CharSequence[]{"function"});
    }

    public void assertException(FinishedSpan finishedSpan) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    static class CircuitService {
        private static final Logger log = LoggerFactory.getLogger(CircuitService.class);
        private final ReactiveCircuitBreakerFactory factory;
        private final Tracer tracer;
        Span firstSpan;
        Span secondSpan;

        CircuitService(ReactiveCircuitBreakerFactory factory, Tracer tracer) {
            this.factory = factory;
            this.tracer = tracer;
        }

        Mono<String> call() {
            return this.factory.create("circuit").run(Mono.defer(() -> {
                this.firstSpan = this.tracer.currentSpan();
                log.info("<ACCEPTANCE_TEST> <TRACE:{}> Hello from consumer", (Object)this.tracer.currentSpan().context().traceId());
                return Mono.error((Throwable)new IllegalStateException("boom"));
            }), throwable -> {
                this.secondSpan = this.tracer.currentSpan();
                log.info("<ACCEPTANCE_TEST> <TRACE:{}> Hello from producer", (Object)this.tracer.currentSpan().context().traceId());
                return Mono.just((Object)"fallback");
            });
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfig {
        @Bean
        ReactiveResilience4JCircuitBreakerFactory reactiveResilience4JCircuitBreakerFactory() {
            return new ReactiveResilience4JCircuitBreakerFactory();
        }

        @Bean
        CircuitService circuitService(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, Tracer tracer) {
            return new CircuitService(reactiveCircuitBreakerFactory, tracer);
        }
    }
}

