/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceScheduledThreadPoolExecutor;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListenerAccessor;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

public abstract class TraceScheduledThreadPoolExecutorTests
implements TestTracingAwareSupplier {
    ScheduledThreadPoolExecutor delegate = new ScheduledThreadPoolExecutor(1);
    BeanFactory beanFactory = this.beanFactory();
    LazyTraceScheduledThreadPoolExecutor traceThreadPoolTaskExecutor = this.executor();

    protected LazyTraceScheduledThreadPoolExecutor executor() {
        return new LazyTraceScheduledThreadPoolExecutor(1, this.beanFactory, this.delegate, "foo");
    }

    @BeforeEach
    void setup() {
        SleuthContextListenerAccessor.set(this.beanFactory, true);
    }

    @AfterEach
    void clear() {
        this.delegate.shutdown();
        this.traceThreadPoolTaskExecutor.shutdown();
    }

    private BeanFactory beanFactory() {
        BeanFactory beanFactory = (BeanFactory)BDDMockito.mock(BeanFactory.class);
        BDDMockito.given((Object)beanFactory.getBean(Tracer.class)).willReturn((Object)this.tracerTest().tracing().tracer());
        BDDMockito.given((Object)beanFactory.getBean(SpanNamer.class)).willReturn((Object)new DefaultSpanNamer());
        return beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.schedule(this.aRunnable(executed, span), 1L, TimeUnit.MILLISECONDS).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((boolean)executed.get()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_decorate_task_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            Runnable runnable = this.aRunnable(executed, span);
            this.traceThreadPoolTaskExecutor.decorateTask(runnable, this.runnableScheduledFuture(runnable)).run();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_decorate_task_trace_callable() throws Exception {
        RunnableScheduledFuture fromCallable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            Callable<Span> callable = this.aCallable(span);
            fromCallable = this.traceThreadPoolTaskExecutor.decorateTask(callable, this.runnableScheduledFuture(callable));
            fromCallable.run();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then(fromCallable.get(10L, TimeUnit.MILLISECONDS)).isNotNull());
    }

    private RunnableScheduledFuture<Span> runnableScheduledFuture(final Callable<Span> run) {
        return new RunnableScheduledFuture<Span>(){
            private Span result;

            @Override
            public boolean isPeriodic() {
                return false;
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return 0L;
            }

            @Override
            public int compareTo(Delayed o) {
                return 0;
            }

            @Override
            public void run() {
                try {
                    this.result = (Span)run.call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public Span get() throws InterruptedException, ExecutionException {
                return this.result;
            }

            @Override
            public Span get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.result;
            }
        };
    }

    private RunnableScheduledFuture<Object> runnableScheduledFuture(final Runnable run) {
        return new RunnableScheduledFuture<Object>(){

            @Override
            public boolean isPeriodic() {
                return false;
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return 0L;
            }

            @Override
            public int compareTo(Delayed o) {
                return 0;
            }

            @Override
            public void run() {
                run.run();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                return null;
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_trace_callable() throws Exception {
        Span spanFromCallable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromCallable = (Span)this.traceThreadPoolTaskExecutor.schedule(this.aCallable(span), 1L, TimeUnit.MILLISECONDS).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromCallable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_at_fixed_rate_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleAtFixedRate(this.aRunnable(executed, span), 1L, 1L, TimeUnit.MILLISECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_with_fixed_delay_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleWithFixedDelay(this.aRunnable(executed, span), 1L, 1L, TimeUnit.MILLISECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.execute(this.aRunnable(executed, span));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceThreadPoolTaskExecutor.submit(this.aCallable(span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    Runnable aRunnable(AtomicBoolean executed, Span currentSpan) {
        return () -> {
            Span span = this.tracerTest().tracing().tracer().currentSpan();
            BDDAssertions.then((Object)span).isNotNull();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(currentSpan.context().traceId());
            executed.set(true);
        };
    }

    Callable<Span> aCallable(Span currentSpan) {
        return () -> {
            Span span = this.tracerTest().tracing().tracer().currentSpan();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(currentSpan.context().traceId());
            return span;
        };
    }
}

