/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@ContextConfiguration(classes={ConfigureThreadPoolTaskScheduler.class})
@TestPropertySource(properties={"spring.sleuth.scheduled.enabled=false"})
public abstract class AsyncDisabledTests {
    @Autowired
    CurrentTraceContext currentTraceContext;
    @Autowired
    @Qualifier(value="traceSenderThreadPool")
    Executor executor;

    @Test
    public void should_not_wrap_scheduler() throws InterruptedException {
        LinkedBlockingQueue spans = new LinkedBlockingQueue();
        this.executor.execute(() -> spans.add(this.currentTraceContext.context() != null));
        BDDAssertions.then((Boolean)((Boolean)spans.take())).isFalse();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableAsync
    static class ConfigureThreadPoolTaskScheduler {
        ConfigureThreadPoolTaskScheduler() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"traceSenderThreadPool"})
        public ThreadPoolTaskScheduler traceSenderThreadPool() {
            return new ThreadPoolTaskScheduler();
        }
    }
}

