/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.annotation.TagValueResolver;
import org.springframework.cloud.sleuth.instrument.annotation.SpanTagAnnotationHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class SpanTagAnnotationHandlerTests {
    @Autowired
    BeanFactory beanFactory;
    @Autowired
    TagValueResolver tagValueResolver;
    SpanTagAnnotationHandler handler;

    @BeforeEach
    public void setup() {
        this.handler = new SpanTagAnnotationHandler(this.beanFactory);
    }

    @Test
    public void shouldUseCustomTagValueResolver() throws NoSuchMethodException, SecurityException {
        Method method = AnnotationMockClass.class.getMethod("getAnnotationForTagValueResolver", String.class);
        Annotation annotation = method.getParameterAnnotations()[0][0];
        if (annotation instanceof SpanTag) {
            String resolvedValue = this.handler.resolveTagValue((SpanTag)annotation, (Object)"test");
            Assertions.assertThat((String)resolvedValue).isEqualTo("Value from myCustomTagValueResolver");
        } else {
            Assertions.fail((String)"Annotation was not SleuthSpanTag");
        }
    }

    @Test
    public void shouldUseTagValueExpression() throws NoSuchMethodException, SecurityException {
        Method method = AnnotationMockClass.class.getMethod("getAnnotationForTagValueExpression", String.class);
        Annotation annotation = method.getParameterAnnotations()[0][0];
        if (annotation instanceof SpanTag) {
            String resolvedValue = this.handler.resolveTagValue((SpanTag)annotation, (Object)"test");
            Assertions.assertThat((String)resolvedValue).isEqualTo("hello characters");
        } else {
            Assertions.fail((String)"Annotation was not SleuthSpanTag");
        }
    }

    @Test
    public void shouldReturnArgumentToString() throws NoSuchMethodException, SecurityException {
        Method method = AnnotationMockClass.class.getMethod("getAnnotationForArgumentToString", Long.class);
        Annotation annotation = method.getParameterAnnotations()[0][0];
        if (annotation instanceof SpanTag) {
            String resolvedValue = this.handler.resolveTagValue((SpanTag)annotation, (Object)15);
            Assertions.assertThat((String)resolvedValue).isEqualTo("15");
        } else {
            Assertions.fail((String)"Annotation was not SleuthSpanTag");
        }
    }

    protected class AnnotationMockClass {
        protected AnnotationMockClass() {
        }

        @NewSpan
        public void getAnnotationForTagValueResolver(@SpanTag(key="test", resolver=TagValueResolver.class) String test) {
        }

        @NewSpan
        public void getAnnotationForTagValueExpression(@SpanTag(key="test", expression="'hello' + ' characters'") String test) {
        }

        @NewSpan
        public void getAnnotationForArgumentToString(@SpanTag(value="test") Long param) {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfiguration {
        @Bean(name={"myCustomTagValueResolver"})
        public TagValueResolver tagValueResolver() {
            return parameter -> "Value from myCustomTagValueResolver";
        }
    }
}

