/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class SleuthSpanCreatorAspectNegativeTests {
    @Autowired
    NotAnnotatedTestBeanInterface testBean;
    @Autowired
    TestBeanInterface annotatedTestBean;
    @Autowired
    TestSpanHandler spans;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    @Test
    public void shouldNotCallAdviceForNotAnnotatedBean() {
        this.testBean.testMethod();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
    }

    @Test
    public void shouldCallAdviceForAnnotatedBean() throws Throwable {
        this.annotatedTestBean.testMethod();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method");
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfiguration {
        @Bean
        NotAnnotatedTestBeanInterface testBean() {
            return new NotAnnotatedTestBean();
        }

        @Bean
        TestBeanInterface annotatedTestBean() {
            return new TestBean();
        }
    }

    protected static class TestBean
    implements TestBeanInterface {
        protected TestBean() {
        }

        @Override
        public void testMethod() {
        }

        @Override
        @NewSpan
        public void testMethod2() {
        }

        @Override
        @NewSpan(name="testMethod3")
        public void testMethod3() {
        }

        @Override
        public void testMethod4() {
        }

        @Override
        public void testMethod5(String test) {
        }

        @Override
        @NewSpan(name="testMethod6")
        public void testMethod6(@SpanTag(value="testTag6") String test) {
        }

        @Override
        public void testMethod7() {
        }
    }

    protected static class NotAnnotatedTestBean
    implements NotAnnotatedTestBeanInterface {
        protected NotAnnotatedTestBean() {
        }

        @Override
        public void testMethod() {
        }
    }

    protected static interface TestBeanInterface {
        @NewSpan
        public void testMethod();

        public void testMethod2();

        public void testMethod3();

        @NewSpan(name="testMethod4")
        public void testMethod4();

        @NewSpan(name="testMethod5")
        public void testMethod5(@SpanTag(value="testTag") String var1);

        public void testMethod6(String var1);

        public void testMethod7();
    }

    protected static interface NotAnnotatedTestBeanInterface {
        public void testMethod();
    }
}

