/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorHooksHelper;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthContextOperator;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.NonNull;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ReactorSleuth {
    private static final Log log = LogFactory.getLog(ReactorSleuth.class);
    public static Function<Context, Context> contextWrappingFunction = Function.identity();

    private ReactorSleuth() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + springContext + "]"));
        }
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        return Operators.liftPublisher(p -> !(p instanceof Fuseable.ScalarCallable), ReactorSleuth.liftFunction(springContext, lazyCurrentTraceContext, lazyTracer));
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> onEachOperatorForOnEachInstrumentation(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + springContext + "]"));
        }
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        Predicate<Publisher> shouldDecorate = ReactorHooksHelper::shouldDecorate;
        BiFunction lifter = ReactorSleuth.liftFunction(springContext, lazyCurrentTraceContext, lazyTracer);
        return Operators.liftPublisher(shouldDecorate, ReactorHooksHelper.named("org.springframework.cloud.sleuth.instrument.reactor.ReactorHooksHelper.ScopePassingLifter", lifter));
    }

    static <O> BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super O>> liftFunction(ConfigurableApplicationContext springContext, LazyBean<CurrentTraceContext> lazyCurrentTraceContext, LazyBean<Tracer> lazyTracer) {
        return (p, sub) -> {
            CurrentTraceContext currentTraceContext;
            if (!springContext.isActive() || !springContext.isRunning()) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] is not yet refreshed. This is unexpected. Reactor Context is [" + ReactorSleuth.context(sub) + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            Context context = ReactorSleuth.context(sub);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if ((currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get()) == null) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] did not return a CurrentTraceContext. Reactor Context is [" + context + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            TraceContext parent = ReactorSleuth.traceContext(context, currentTraceContext);
            if (parent == null) {
                return sub;
            }
            if (sub instanceof ScopePassingSpanSubscriber) {
                ScopePassingSpanSubscriber scopePassing = (ScopePassingSpanSubscriber)sub;
                if (scopePassing.parent.equals(parent)) {
                    return sub;
                }
            }
            context = ReactorSleuth.contextWithBeans(context, lazyTracer, lazyCurrentTraceContext);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating a scope passing span subscriber with Reactor Context [" + context + "] and name [" + ReactorSleuth.name(sub) + "]"));
            }
            return new ScopePassingSpanSubscriber(sub, context, currentTraceContext, parent);
        };
    }

    private static <T> Context contextWithBeans(Context context, LazyBean<Tracer> tracer, LazyBean<CurrentTraceContext> currentTraceContext) {
        if (!context.hasKey(Tracer.class)) {
            context = context.put(Tracer.class, (Object)tracer.getOrError());
        }
        if (!context.hasKey(CurrentTraceContext.class)) {
            context = context.put(CurrentTraceContext.class, (Object)currentTraceContext.getOrError());
        }
        return context;
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> springContextSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Spring Context passing operator [" + springContext + "]"));
        }
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        return Operators.liftPublisher(p -> !(p instanceof Fuseable.ScalarCallable) && springContext.isActive(), (p, sub) -> {
            Context ctxBefore = ReactorSleuth.context(sub);
            Context context = ReactorSleuth.contextWithBeans(ctxBefore, lazyTracer, lazyCurrentTraceContext);
            if (context == ctxBefore) {
                return sub;
            }
            return new SleuthContextOperator(context, sub);
        });
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> onLastOperatorForOnEachInstrumentation(ConfigurableApplicationContext springContext) {
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        BiFunction scopePassingSpanSubscriber = ReactorSleuth.liftFunction(springContext, lazyCurrentTraceContext, lazyTracer);
        BiFunction<Publisher, CoreSubscriber, CoreSubscriber> skipIfNoTraceCtx = (pub, sub) -> {
            TraceContext traceContext = ((CurrentTraceContext)lazyCurrentTraceContext.get()).context();
            if (ReactorSleuth.context(sub).getOrDefault(TraceContext.class, null) == traceContext) {
                return sub;
            }
            return (CoreSubscriber)scopePassingSpanSubscriber.apply((Publisher)pub, (CoreSubscriber)sub);
        };
        return Operators.liftPublisher(p -> {
            CurrentTraceContext currentTraceContext;
            boolean addContext;
            if (ReactorHooksHelper.isTraceContextPropagator(p)) {
                return false;
            }
            boolean bl = addContext = !(p instanceof Fuseable.ScalarCallable) && springContext.isActive();
            if (addContext && (currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get()) != null) {
                addContext = currentTraceContext.context() != null;
            }
            return addContext;
        }, ReactorHooksHelper.named("org.springframework.cloud.sleuth.instrument.reactor.ReactorHooksHelper.ScopePassingLifter", skipIfNoTraceCtx));
    }

    private static <T> Context context(CoreSubscriber<? super T> sub) {
        try {
            return sub.currentContext();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred while trying to retrieve the context", (Throwable)ex);
            }
            return Context.empty();
        }
    }

    static String name(CoreSubscriber<?> sub) {
        return Scannable.from(sub).name();
    }

    static TraceContext traceContext(Context context, CurrentTraceContext fallback) {
        if (context.hasKey(TraceContext.class)) {
            return (TraceContext)context.get(TraceContext.class);
        }
        return fallback.context();
    }

    public static Function<Runnable, Runnable> scopePassingOnScheduleHook(ConfigurableApplicationContext springContext) {
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        return delegate -> {
            if (springContext.isActive()) {
                CurrentTraceContext currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get();
                if (currentTraceContext == null) {
                    return delegate;
                }
                TraceContext traceContext = currentTraceContext.context();
                return () -> {
                    try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
                        delegate.run();
                    }
                };
            }
            return delegate;
        };
    }

    public static <T> Mono<T> tracedMono(@NonNull Tracer tracer, @NonNull CurrentTraceContext currentTraceContext, @NonNull String childSpanName, @NonNull Supplier<Mono<T>> supplier, @NonNull BiConsumer<T, Span> spanCustomizer) {
        return ReactorSleuth.runMonoSupplierInScope(supplier, spanCustomizer).contextWrite(context -> ReactorSleuth.enhanceContext(tracer, currentTraceContext, context, childSpanName));
    }

    public static <T> Mono<T> tracedMono(@NonNull Tracer tracer, @NonNull CurrentTraceContext currentTraceContext, @NonNull String childSpanName, @NonNull Supplier<Mono<T>> supplier, @NonNull BiConsumer<T, Span> spanCustomizer, @NonNull Function<Span, Span> spanFunction) {
        return ReactorSleuth.runMonoSupplierInScope(supplier, spanCustomizer).contextWrite(context -> ReactorSleuth.enhanceContext(tracer, currentTraceContext, context, childSpanName, spanFunction));
    }

    private static <T> Mono<T> runMonoSupplierInScope(Supplier<Mono<T>> supplier, BiConsumer<T, Span> spanCustomizer) {
        return Mono.deferContextual(contextView -> {
            Span span = (Span)contextView.get(Span.class);
            Tracer.SpanInScope scope = (Tracer.SpanInScope)contextView.get(Tracer.SpanInScope.class);
            return ((Mono)supplier.get()).map(t -> {
                spanCustomizer.accept(t, span);
                return t;
            }).doOnError(arg_0 -> ((Span)span).error(arg_0)).doFinally(signalType -> {
                span.end();
                scope.close();
            });
        });
    }

    public static <T> Mono<T> tracedMono(@NonNull Tracer tracer, @NonNull CurrentTraceContext currentTraceContext, @NonNull String childSpanName, @NonNull Supplier<Mono<T>> supplier) {
        return ReactorSleuth.tracedMono(tracer, currentTraceContext, childSpanName, supplier, (o, span) -> {});
    }

    public static <T> Mono<T> tracedMono(@NonNull Tracer tracer, @NonNull Span span, @NonNull Supplier<Mono<T>> supplier) {
        return ReactorSleuth.runMonoSupplierInScope(supplier, (o, span1) -> {}).contextWrite(context -> ReactorSleuth.putSpanInScope(tracer, context, span));
    }

    public static <T> Flux<T> tracedFlux(@NonNull Tracer tracer, @NonNull CurrentTraceContext currentTraceContext, @NonNull String childSpanName, @NonNull Supplier<Flux<T>> supplier, @NonNull BiConsumer<T, Span> spanCustomizer) {
        return ReactorSleuth.runFluxSupplierInScope(supplier, spanCustomizer).contextWrite(context -> ReactorSleuth.enhanceContext(tracer, currentTraceContext, context, childSpanName));
    }

    public static <T> Flux<T> tracedFlux(@NonNull Tracer tracer, @NonNull CurrentTraceContext currentTraceContext, @NonNull String childSpanName, @NonNull Supplier<Flux<T>> supplier, @NonNull BiConsumer<T, Span> spanCustomizer, @NonNull Function<Span, Span> spanFunction) {
        return ReactorSleuth.runFluxSupplierInScope(supplier, spanCustomizer).contextWrite(context -> ReactorSleuth.enhanceContext(tracer, currentTraceContext, context, childSpanName, spanFunction));
    }

    public static <T> Flux<T> tracedFlux(@NonNull Tracer tracer, @NonNull Span span, @NonNull Supplier<Flux<T>> supplier) {
        return ReactorSleuth.runFluxSupplierInScope(supplier, (o, span1) -> {}).contextWrite(context -> ReactorSleuth.putSpanInScope(tracer, context, span));
    }

    private static <T> Flux<T> runFluxSupplierInScope(Supplier<Flux<T>> supplier, BiConsumer<T, Span> spanCustomizer) {
        return Flux.deferContextual(contextView -> {
            Span span = (Span)contextView.get(Span.class);
            Tracer.SpanInScope scope = (Tracer.SpanInScope)contextView.get(Tracer.SpanInScope.class);
            return ((Flux)supplier.get()).map(t -> {
                spanCustomizer.accept(t, span);
                return t;
            }).doOnError(arg_0 -> ((Span)span).error(arg_0)).doFinally(signalType -> {
                span.end();
                scope.close();
            });
        });
    }

    public static <T> Flux<T> tracedFlux(@NonNull Tracer tracer, @NonNull CurrentTraceContext currentTraceContext, @NonNull String childSpanName, @NonNull Supplier<Flux<T>> supplier) {
        return ReactorSleuth.tracedFlux(tracer, currentTraceContext, childSpanName, supplier, (o, span) -> {});
    }

    private static Span childSpanFromContext(Tracer tracer, CurrentTraceContext currentTraceContext, Context context, String childSpanName) {
        return ReactorSleuth.childSpanFromContext(currentTraceContext, context, childSpanName, (Span span) -> span == null ? tracer.nextSpan() : tracer.nextSpan(span));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Span childSpanFromContext(CurrentTraceContext currentTraceContext, Context context, String childSpanName, Function<Span, Span> spanSupplier) {
        TraceContext traceContext = (TraceContext)context.getOrDefault(TraceContext.class, null);
        Span span = (Span)context.getOrDefault(Span.class, null);
        if (traceContext == null && span == null) {
            span = spanSupplier.apply(null);
            if (!log.isDebugEnabled()) return span.name(childSpanName).start();
            log.debug((Object)("There was no previous span in reactor context, created a new one [" + span + "]"));
            return span.name(childSpanName).start();
        } else if (traceContext != null && span == null) {
            try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found a trace context in reactor context [" + traceContext + "]"));
                }
                span = spanSupplier.apply(null);
                if (!log.isDebugEnabled()) return span.name(childSpanName).start();
                log.debug((Object)("Created a child span [" + span + "]"));
                return span.name(childSpanName).start();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a span in reactor context [" + span + "]"));
            }
            span = spanSupplier.apply(span);
            if (!log.isDebugEnabled()) return span.name(childSpanName).start();
            log.debug((Object)("Created a child span [" + span + "]"));
        }
        return span.name(childSpanName).start();
    }

    public static Context enhanceContext(Tracer tracer, CurrentTraceContext currentTraceContext, Context context, String childSpanName, Function<Span, Span> spanSupplier) {
        Span span = ReactorSleuth.childSpanFromContext(currentTraceContext, context, childSpanName, spanSupplier);
        return ReactorSleuth.putSpanInScope(tracer, context, span);
    }

    public static Context enhanceContext(Tracer tracer, CurrentTraceContext currentTraceContext, Context context, String childSpanName) {
        Span span = ReactorSleuth.childSpanFromContext(tracer, currentTraceContext, context, childSpanName);
        return ReactorSleuth.putSpanInScope(tracer, context, span);
    }

    public static Context putSpanInScope(Tracer tracer, Context context, Span span) {
        Context newContext = context.put(Span.class, (Object)span).put(TraceContext.class, (Object)span.context()).put(Tracer.SpanInScope.class, (Object)tracer.withSpan(span));
        return ReactorSleuth.wrapContext(newContext);
    }

    public static Context wrapContext(Context context) {
        return contextWrappingFunction.apply(context);
    }

    public static Span spanFromContext(Tracer tracer, CurrentTraceContext currentTraceContext, ContextView context) {
        Span span = (Span)context.getOrDefault(Span.class, null);
        if (span != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a span in reactor context [" + span + "]"));
            }
            return span;
        }
        TraceContext traceContext = (TraceContext)context.getOrDefault(TraceContext.class, null);
        if (traceContext != null) {
            try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found a trace context in reactor context [" + traceContext + "]"));
                }
                Span span2 = tracer.currentSpan();
                return span2;
            }
        }
        Span newSpan = tracer.nextSpan().start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("No span was found - will create a new one [" + newSpan + "]"));
        }
        return newSpan;
    }
}

