/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.event.CommandStartedEvent;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoSpanCustomizer;

public class TraceMongoClusterIdSpanCustomizer
implements TraceMongoSpanCustomizer {
    @Override
    public void customizeCommandStartSpan(CommandStartedEvent event, Span.Builder spanBuilder) {
        ConnectionId connectionId;
        ConnectionDescription connectionDescription = event.getConnectionDescription();
        if (connectionDescription != null && (connectionId = connectionDescription.getConnectionId()) != null) {
            spanBuilder.tag("mongodb.cluster_id", connectionId.getServerId().getClusterId().getValue());
        }
    }
}

