/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.internal.SleuthContextListener;

public final class ContextUtil {
    private static final Log log = LogFactory.getLog(ContextUtil.class);

    private ContextUtil() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static boolean isContextUnusable(BeanFactory beanFactory) {
        SleuthContextListener listener = SleuthContextListener.getBean(beanFactory);
        boolean contextUnusable = listener.isUnusable();
        if (contextUnusable && log.isDebugEnabled()) {
            log.debug((Object)("Context [" + Integer.toHexString(beanFactory.hashCode()) + "] is either not refreshed or is closed"));
        }
        return contextUnusable;
    }
}

