/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.task;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.instrument.task.SleuthTaskSpan;

public class TraceCommandLineRunner
implements CommandLineRunner {
    private final BeanFactory beanFactory;
    private final CommandLineRunner delegate;
    private final String beanName;
    private Tracer tracer;

    public TraceCommandLineRunner(BeanFactory beanFactory, CommandLineRunner delegate, String beanName) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = beanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String ... args) throws Exception {
        AssertingSpan span = SleuthTaskSpan.TASK_RUNNER_SPAN.wrap(this.tracer().nextSpan()).name(this.beanName);
        try (Tracer.SpanInScope spanInScope = this.tracer().withSpan(span.start());){
            this.delegate.run(args);
        }
        finally {
            span.end();
        }
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

