/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceCircuitBreaker;

@Aspect
public class TraceCircuitBreakerFactoryAspect {
    private final Tracer tracer;

    public TraceCircuitBreakerFactoryAspect(Tracer tracer) {
        this.tracer = tracer;
    }

    @Pointcut(value="execution(public * org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory.create(..))")
    private void anyCircuitBreakerFactoryCreate() {
    }

    @Around(value="anyCircuitBreakerFactoryCreate()")
    public Object wrapFactory(ProceedingJoinPoint pjp) throws Throwable {
        CircuitBreaker circuitBreaker = (CircuitBreaker)pjp.proceed();
        return new TraceCircuitBreaker(circuitBreaker, this.tracer);
    }
}

