/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.propagation.TraceContextOrSamplingFlags;
import java.io.Closeable;
import java.util.Map;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.BraveScopedSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanBuilder;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanCustomizer;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanInScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContextBuilder;

public class BraveTracer
implements Tracer {
    private final brave.Tracer tracer;
    private final BraveBaggageManager braveBaggageManager;
    private final CurrentTraceContext currentTraceContext;

    @Deprecated
    public BraveTracer(brave.Tracer tracer, BraveBaggageManager braveBaggageManager) {
        this.tracer = tracer;
        this.braveBaggageManager = braveBaggageManager;
        this.currentTraceContext = null;
    }

    public BraveTracer(brave.Tracer tracer, CurrentTraceContext context, BraveBaggageManager braveBaggageManager) {
        this.tracer = tracer;
        this.braveBaggageManager = braveBaggageManager;
        this.currentTraceContext = context;
    }

    public Span nextSpan(Span parent) {
        if (parent == null) {
            return this.nextSpan();
        }
        brave.propagation.TraceContext context = ((BraveTraceContext)parent.context()).traceContext;
        if (context == null) {
            return null;
        }
        return new BraveSpan(this.tracer.nextSpan(TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)context)));
    }

    public Tracer.SpanInScope withSpan(Span span) {
        if (span == null) {
            this.currentTraceContext.maybeScope(null);
            return Tracer.SpanInScope.NOOP;
        }
        return new BraveSpanInScope((Closeable)this.currentTraceContext.maybeScope(span.context()));
    }

    public SpanCustomizer currentSpanCustomizer() {
        return new BraveSpanCustomizer(this.tracer.currentSpanCustomizer());
    }

    public Span currentSpan() {
        brave.Span currentSpan = this.tracer.currentSpan();
        if (currentSpan == null) {
            return null;
        }
        return new BraveSpan(currentSpan);
    }

    public Span nextSpan() {
        return new BraveSpan(this.tracer.nextSpan());
    }

    public ScopedSpan startScopedSpan(String name) {
        return new BraveScopedSpan(this.tracer.startScopedSpan(name));
    }

    public Span.Builder spanBuilder() {
        return new BraveSpanBuilder(this.tracer);
    }

    public TraceContext.Builder traceContextBuilder() {
        return new BraveTraceContextBuilder();
    }

    public Map<String, String> getAllBaggage() {
        return this.braveBaggageManager.getAllBaggage();
    }

    public BaggageInScope getBaggage(String name) {
        return this.braveBaggageManager.getBaggage(name);
    }

    public BaggageInScope getBaggage(TraceContext traceContext, String name) {
        return this.braveBaggageManager.getBaggage(traceContext, name);
    }

    public BaggageInScope createBaggage(String name) {
        return this.braveBaggageManager.createBaggage(name);
    }

    public BaggageInScope createBaggage(String name, String value) {
        return this.braveBaggageManager.createBaggage(name).set(value);
    }

    public CurrentTraceContext currentTraceContext() {
        return this.currentTraceContext;
    }
}

