/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.Tracing;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.List;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanBuilder;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.propagation.Propagator;

public class BravePropagator
implements Propagator {
    private final Tracing tracing;

    public BravePropagator(Tracing tracing) {
        this.tracing = tracing;
    }

    public List<String> fields() {
        return this.tracing.propagation().keys();
    }

    public <C> void inject(TraceContext traceContext, C carrier, Propagator.Setter<C> setter) {
        this.tracing.propagation().injector((arg_0, arg_1, arg_2) -> setter.set(arg_0, arg_1, arg_2)).inject(BraveTraceContext.toBrave(traceContext), carrier);
    }

    public <C> Span.Builder extract(C carrier, Propagator.Getter<C> getter) {
        TraceContextOrSamplingFlags extract = this.tracing.propagation().extractor((arg_0, arg_1) -> getter.get(arg_0, arg_1)).extract(carrier);
        if (extract.samplingFlags() == SamplingFlags.EMPTY) {
            return new BraveSpanBuilder(this.tracing.tracer());
        }
        return BraveSpanBuilder.toBuilder(this.tracing.tracer(), extract);
    }
}

