/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import brave.Span;
import brave.jms.JmsTracing;
import brave.propagation.CurrentTraceContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter;

final class TracingMessagingMessageListenerAdapter
extends MessagingMessageListenerAdapter {
    final JmsTracing jmsTracing;
    final CurrentTraceContext current;

    TracingMessagingMessageListenerAdapter(JmsTracing jmsTracing, CurrentTraceContext current) {
        this.jmsTracing = jmsTracing;
        this.current = current;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        Span span = this.jmsTracing.nextSpan(message).name("on-message").start();
        try (CurrentTraceContext.Scope ws = this.current.newScope(span.context());){
            super.onMessage(message, session);
        }
        catch (Error | RuntimeException | JMSException e) {
            span.error(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

