/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import brave.Tag;
import brave.Tracer;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import zipkin2.Span;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.brave.ZipkinSpanHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Tracer.class, EndpointLocator.class})
class ZipkinBraveConfiguration {
    static final Comparator<SpanHandler> SPAN_HANDLER_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof ZipkinSpanHandler) {
            if (o2 instanceof ZipkinSpanHandler) {
                return 0;
            }
            return 1;
        }
        if (o2 instanceof ZipkinSpanHandler) {
            return -1;
        }
        return 0;
    };
    private static final Log log = LogFactory.getLog(ZipkinBraveConfiguration.class);

    ZipkinBraveConfiguration() {
    }

    @Bean
    SpanHandler zipkinSpanHandler(@Nullable List<Reporter<Span>> spanReporters, @Nullable Tag<Throwable> errorTag) {
        if (spanReporters == null) {
            return SpanHandler.NOOP;
        }
        LinkedHashSet<Reporter<Span>> reporters = new LinkedHashSet<Reporter<Span>>(spanReporters);
        reporters.remove(Reporter.NOOP);
        if (spanReporters.isEmpty()) {
            return SpanHandler.NOOP;
        }
        CompositeSpanReporter spanReporter = reporters.size() == 1 ? (Reporter)reporters.iterator().next() : new CompositeSpanReporter(reporters.toArray(new Reporter[0]));
        ZipkinSpanHandler.Builder builder = ZipkinSpanHandler.newBuilder((Reporter)spanReporter);
        if (errorTag != null) {
            builder.errorTag(errorTag);
        }
        return builder.build();
    }

    @Bean
    TracingCustomizer reorderZipkinHandlersLast() {
        return builder -> {
            ArrayList<SpanHandler> configuredSpanHandlers = new ArrayList<SpanHandler>(builder.spanHandlers());
            configuredSpanHandlers.sort(SPAN_HANDLER_COMPARATOR);
            builder.clearSpanHandlers();
            for (SpanHandler spanHandler : configuredSpanHandlers) {
                builder.addSpanHandler(spanHandler);
            }
        };
    }

    static final class CompositeSpanReporter
    implements Reporter<Span> {
        final Reporter<Span>[] reporters;

        CompositeSpanReporter(Reporter<Span>[] reporters) {
            this.reporters = reporters;
        }

        public void report(Span span) {
            for (Reporter<Span> reporter : this.reporters) {
                try {
                    reporter.report((Object)span);
                }
                catch (RuntimeException ex) {
                    log.warn((Object)("Exception occurred while trying to report the span " + span), (Throwable)ex);
                }
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.reporters);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CompositeSpanReporter)) {
                return false;
            }
            return Arrays.equals(((CompositeSpanReporter)obj).reporters, this.reporters);
        }

        public String toString() {
            return Arrays.toString(this.reporters);
        }
    }
}

