/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.scheduling;

import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.scheduling.SleuthSchedulingProperties;
import org.springframework.cloud.sleuth.instrument.scheduling.TraceSchedulingAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
@ConditionalOnProperty(value={"spring.sleuth.scheduled.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@EnableConfigurationProperties(value={SleuthSchedulingProperties.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceSchedulingAutoConfiguration {
    @Bean
    TraceSchedulingAspect traceSchedulingAspect(Tracer tracer, SleuthSchedulingProperties sleuthSchedulingProperties) {
        String skipPatternString = sleuthSchedulingProperties.getSkipPattern();
        Pattern skipPattern = skipPatternString != null ? Pattern.compile(skipPatternString) : null;
        return new TraceSchedulingAspect(tracer, skipPattern);
    }
}

