/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public final class DeploymentPropertiesUtils {
    private static final Pattern DEPLOYMENT_PARAMS_PATTERN = Pattern.compile("(\\s(?=([^\\\"']*[\\\"'][^\\\"']*[\\\"'])*[^\\\"']*$))");

    private DeploymentPropertiesUtils() {
    }

    public static Map<String, String> parse(String s) {
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        ArrayList<String> pairs = new ArrayList<String>();
        String[] candidates = StringUtils.commaDelimitedListToStringArray((String)s);
        for (int i = 0; i < candidates.length; ++i) {
            if (i > 0 && !candidates[i].contains("=")) {
                pairs.set(pairs.size() - 1, (String)pairs.get(pairs.size() - 1) + "," + candidates[i]);
                continue;
            }
            pairs.add(candidates[i]);
        }
        for (String pair : pairs) {
            DeploymentPropertiesUtils.addKeyValuePairAsProperty(pair, deploymentProperties);
        }
        return deploymentProperties;
    }

    public static String format(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder(15 * properties.size());
        for (Map.Entry<String, String> pair : properties.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pair.getKey()).append("=").append(pair.getValue());
        }
        return sb.toString();
    }

    public static Map<String, String> convert(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.put(key, properties.getProperty(key));
        }
        return result;
    }

    private static void addKeyValuePairAsProperty(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }

    public static List<String> parseParams(List<String> params) {
        ArrayList<String> paramsToUse = new ArrayList<String>();
        if (params != null) {
            for (String param : params) {
                String p;
                Matcher regexMatcher = DEPLOYMENT_PARAMS_PATTERN.matcher(param);
                int start = 0;
                while (regexMatcher.find()) {
                    p = DeploymentPropertiesUtils.removeQuoting(param.substring(start, regexMatcher.start()).trim());
                    if (StringUtils.hasText((String)p)) {
                        paramsToUse.add(p);
                    }
                    start = regexMatcher.start();
                }
                if (param == null || param.length() <= 0 || !StringUtils.hasText((String)(p = DeploymentPropertiesUtils.removeQuoting(param.substring(start, param.length()).trim())))) continue;
                paramsToUse.add(p);
            }
        }
        return paramsToUse;
    }

    private static String removeQuoting(String param) {
        String[] split;
        param = DeploymentPropertiesUtils.removeQuote(param, '\'');
        if (StringUtils.hasText((String)(param = DeploymentPropertiesUtils.removeQuote(param, '\"'))) && (split = param.split("=", 2)).length == 2) {
            String value = DeploymentPropertiesUtils.removeQuote(split[1], '\'');
            value = DeploymentPropertiesUtils.removeQuote(value, '\"');
            param = split[0] + "=" + value;
        }
        return param;
    }

    private static String removeQuote(String param, char c) {
        if (param != null && param.length() > 1 && param.charAt(0) == c && param.charAt(param.length() - 1) == c) {
            param = param.substring(1, param.length() - 1);
        }
        return param;
    }
}

