/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.springframework.cloud.skipper.domain.Package;
import org.springframework.cloud.skipper.domain.PackageMetadata;
import org.springframework.cloud.skipper.io.PackageFileUtils;
import org.springframework.cloud.skipper.io.PackageWriter;
import org.springframework.cloud.skipper.io.TempFileUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.zeroturnaround.zip.ZipUtil;

public class DefaultPackageWriter
implements PackageWriter {
    private Yaml yaml;

    public DefaultPackageWriter() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        this.yaml = new Yaml(dumperOptions);
    }

    @Override
    public File write(Package pkg, File targetDirectory) {
        PackageMetadata packageMetadata = pkg.getMetadata();
        File tmpDir = TempFileUtils.createTempDirectory("skipper" + packageMetadata.getName()).toFile();
        File rootPackageDir = new File(tmpDir, String.format("%s-%s", packageMetadata.getName(), packageMetadata.getVersion()));
        rootPackageDir.mkdir();
        this.writePackage(pkg, rootPackageDir);
        if (!pkg.getDependencies().isEmpty()) {
            File packagesDir = new File(rootPackageDir, "packages");
            packagesDir.mkdir();
            for (Package dependencyPkg : pkg.getDependencies()) {
                File packageDir = new File(packagesDir, dependencyPkg.getMetadata().getName());
                packageDir.mkdir();
                this.writePackage(dependencyPkg, packageDir);
            }
        }
        File targetZipFile = PackageFileUtils.calculatePackageZipFile(pkg.getMetadata(), targetDirectory);
        ZipUtil.pack((File)rootPackageDir, (File)targetZipFile, (boolean)true);
        FileSystemUtils.deleteRecursively((File)tmpDir);
        return targetZipFile;
    }

    private void writePackage(Package pkg, File directory) {
        String packageMetadata = this.generatePackageMetadata(pkg.getMetadata());
        this.writeText(new File(directory, "package.yml"), packageMetadata);
        if (pkg.getConfigValues() != null && StringUtils.hasText((String)pkg.getConfigValues().getRaw())) {
            this.writeText(new File(directory, "values.yml"), pkg.getConfigValues().getRaw());
        }
        if (!pkg.getTemplates().isEmpty()) {
            File templateDir = new File(directory, "templates/");
            templateDir.mkdirs();
            File templateFile = new File(templateDir, pkg.getMetadata().getName() + ".yml");
            this.writeText(templateFile, this.getDefaultTemplate());
        }
    }

    private String getDefaultTemplate() {
        ClassPathResource resource = new ClassPathResource("/org/springframework/cloud/skipper/io/generic-template.yml");
        String genericTempateData = null;
        try {
            genericTempateData = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't load generic template", e);
        }
        return genericTempateData;
    }

    private void writeText(File target, String body) {
        try (FileOutputStream stream = new FileOutputStream(target);){
            StreamUtils.copy((String)body, (Charset)Charset.forName("UTF-8"), (OutputStream)stream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot write file " + target, e);
        }
    }

    private String generatePackageMetadata(PackageMetadata packageMetadata) {
        return this.yaml.dump((Object)packageMetadata);
    }
}

