/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;
import org.springframework.cloud.netflix.ribbon.support.RibbonCommandContext;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;

public class RibbonApacheHttpRequest
extends ContextAwareRequest
implements Cloneable {
    public RibbonApacheHttpRequest(RibbonCommandContext context) {
        super(context);
    }

    public HttpUriRequest toRequest(RequestConfig requestConfig) {
        List values;
        RequestBuilder builder = RequestBuilder.create((String)this.context.getMethod());
        builder.setUri(this.uri);
        for (String name : this.context.getHeaders().keySet()) {
            values = (List)this.context.getHeaders().get((Object)name);
            for (String value : values) {
                builder.addHeader(name, value);
            }
        }
        for (String name : this.context.getParams().keySet()) {
            values = (List)this.context.getParams().get((Object)name);
            for (String value : values) {
                builder.addParameter(name, value);
            }
        }
        if (this.context.getRequestEntity() != null) {
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent(this.context.getRequestEntity());
            Long contentLength = this.context.getContentLength();
            if (("GET".equals(this.context.getMethod()) || "DELETE".equals(this.context.getMethod())) && (contentLength == null || contentLength < 0L)) {
                entity.setContentLength(0L);
            } else if (contentLength != null) {
                entity.setContentLength(contentLength.longValue());
            }
            builder.setEntity((HttpEntity)entity);
        }
        RibbonRequestCustomizer.Runner.customize(this.context.getRequestCustomizers(), builder);
        builder.setConfig(requestConfig);
        return builder.build();
    }

    public RibbonApacheHttpRequest withNewUri(URI uri) {
        return new RibbonApacheHttpRequest(this.newContext(uri));
    }
}

