/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import java.util.concurrent.TimeUnit;

public class RibbonProperties {
    private final IClientConfig config;

    public static RibbonProperties from(IClientConfig config) {
        return new RibbonProperties(config);
    }

    RibbonProperties(IClientConfig config) {
        this.config = config;
    }

    public Integer getConnectionCleanerRepeatInterval() {
        return (Integer)this.get(CommonClientConfigKey.ConnectionCleanerRepeatInterval);
    }

    public int connectionCleanerRepeatInterval() {
        return this.get(CommonClientConfigKey.ConnectionCleanerRepeatInterval, 30000);
    }

    public Integer getConnectTimeout() {
        return (Integer)this.get(CommonClientConfigKey.ConnectTimeout);
    }

    public int connectTimeout() {
        return this.connectTimeout(2000);
    }

    public int connectTimeout(int defaultValue) {
        return this.get(CommonClientConfigKey.ConnectTimeout, defaultValue);
    }

    public Boolean getFollowRedirects() {
        return (Boolean)this.get(CommonClientConfigKey.FollowRedirects);
    }

    public boolean isFollowRedirects() {
        return this.isFollowRedirects(DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS);
    }

    public boolean isFollowRedirects(boolean defaultValue) {
        return this.get(CommonClientConfigKey.FollowRedirects, defaultValue);
    }

    public Integer getMaxConnectionsPerHost() {
        return (Integer)this.get(CommonClientConfigKey.MaxConnectionsPerHost);
    }

    public int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost(50);
    }

    public int maxConnectionsPerHost(int defaultValue) {
        return this.get(CommonClientConfigKey.MaxConnectionsPerHost, defaultValue);
    }

    public Integer getMaxTotalConnections() {
        return (Integer)this.get(CommonClientConfigKey.MaxTotalConnections);
    }

    public int maxTotalConnections() {
        return this.maxTotalConnections(200);
    }

    public int maxTotalConnections(int defaultValue) {
        return this.get(CommonClientConfigKey.MaxTotalConnections, defaultValue);
    }

    public Boolean getOkToRetryOnAllOperations() {
        return (Boolean)this.get(CommonClientConfigKey.OkToRetryOnAllOperations);
    }

    public boolean isOkToRetryOnAllOperations() {
        return this.get(CommonClientConfigKey.OkToRetryOnAllOperations, DefaultClientConfigImpl.DEFAULT_OK_TO_RETRY_ON_ALL_OPERATIONS);
    }

    public Long getPoolKeepAliveTime() {
        Object property = this.config.getProperty(CommonClientConfigKey.PoolKeepAliveTime);
        if (property instanceof Long) {
            return (Long)property;
        }
        return null;
    }

    public long poolKeepAliveTime() {
        Object property = this.config.getProperty(CommonClientConfigKey.PoolKeepAliveTime);
        if (property instanceof Long) {
            return (Long)property;
        }
        return 900L;
    }

    public TimeUnit getPoolKeepAliveTimeUnits() {
        Object property = this.config.getProperty(CommonClientConfigKey.PoolKeepAliveTimeUnits);
        if (property instanceof TimeUnit) {
            return (TimeUnit)((Object)property);
        }
        return DefaultClientConfigImpl.DEFAULT_POOL_KEEP_ALIVE_TIME_UNITS;
    }

    public Integer getPort() {
        return (Integer)this.get(CommonClientConfigKey.Port);
    }

    public int port() {
        return this.get(CommonClientConfigKey.Port, 7001);
    }

    public Integer getReadTimeout() {
        return (Integer)this.get(CommonClientConfigKey.ReadTimeout);
    }

    public int readTimeout() {
        return this.readTimeout(5000);
    }

    public int readTimeout(int defaultValue) {
        return this.get(CommonClientConfigKey.ReadTimeout, defaultValue);
    }

    public Boolean getSecure() {
        return (Boolean)this.get(CommonClientConfigKey.IsSecure);
    }

    public boolean isSecure() {
        return this.isSecure(false);
    }

    public boolean isSecure(boolean defaultValue) {
        return this.get(CommonClientConfigKey.IsSecure, defaultValue);
    }

    public Integer getSecurePort() {
        return (Integer)this.config.get(CommonClientConfigKey.SecurePort);
    }

    public Boolean getUseIPAddrForServer() {
        return (Boolean)this.get(CommonClientConfigKey.UseIPAddrForServer);
    }

    public boolean isUseIPAddrForServer() {
        return this.isUseIPAddrForServer(false);
    }

    public boolean isUseIPAddrForServer(boolean defaultValue) {
        return this.get(CommonClientConfigKey.UseIPAddrForServer, defaultValue);
    }

    public <T> boolean has(IClientConfigKey<T> key) {
        return this.config.containsProperty(key);
    }

    public <T> T get(IClientConfigKey<T> key) {
        return (T)this.config.get(key);
    }

    public <T> T get(IClientConfigKey<T> key, T defaultValue) {
        return (T)this.config.get(key, defaultValue);
    }
}

