/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.metrics;

import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceCanceledEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRenewedEvent;
import org.springframework.cloud.netflix.eureka.server.metrics.EurekaInstanceTagsProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class EurekaInstanceMonitor
implements SmartApplicationListener {
    private final MultiGauge eurekaInstances;
    private final PeerAwareInstanceRegistry instanceRegistry;
    private final EurekaInstanceTagsProvider tagProvider;
    private final Executor executor;

    EurekaInstanceMonitor(MeterRegistry meterRegistry, PeerAwareInstanceRegistry instanceRegistry, EurekaInstanceTagsProvider tagProvider, Executor executor) {
        Objects.requireNonNull(meterRegistry);
        this.instanceRegistry = Objects.requireNonNull(instanceRegistry);
        this.tagProvider = Objects.requireNonNull(tagProvider);
        this.eurekaInstances = MultiGauge.builder((String)"eureka.server.instances").description("Number of application instances registered with the Eureka server.").register(meterRegistry);
        this.executor = executor;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return EurekaInstanceCanceledEvent.class.isAssignableFrom(eventType) || EurekaInstanceRegisteredEvent.class.isAssignableFrom(eventType) || EurekaInstanceRenewedEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.executor.execute(() -> {
            Map<Tags, Long> aggregatedCounts = this.collectAggregatedCounts();
            this.registerMetrics(aggregatedCounts);
        });
    }

    private Map<Tags, Long> collectAggregatedCounts() {
        return this.instanceRegistry.getApplications().getRegisteredApplications().stream().flatMap(application -> application.getInstances().stream()).collect(Collectors.groupingBy(this.tagProvider::eurekaInstanceTags, Collectors.counting()));
    }

    private void registerMetrics(Map<Tags, Long> aggregatedCounts) {
        this.eurekaInstances.register((Iterable)aggregatedCounts.entrySet().stream().map(entry -> MultiGauge.Row.of((Tags)((Tags)entry.getKey()), (Number)((Number)entry.getValue()))).collect(Collectors.toList()), true);
    }
}

