/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceCanceledEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRenewedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class InstanceRegistry
extends PeerAwareInstanceRegistryImpl
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(InstanceRegistry.class);
    private ApplicationContext ctxt;
    private final int defaultOpenForTrafficCount;

    public InstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, EurekaServerHttpClientFactory eurekaServerHttpClientFactory, int expectedNumberOfClientsSendingRenews, int defaultOpenForTrafficCount) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient, eurekaServerHttpClientFactory);
        this.expectedNumberOfClientsSendingRenews = expectedNumberOfClientsSendingRenews;
        this.defaultOpenForTrafficCount = defaultOpenForTrafficCount;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.ctxt = context;
    }

    public void openForTraffic(ApplicationInfoManager applicationInfoManager, int count) {
        super.openForTraffic(applicationInfoManager, count == 0 ? this.defaultOpenForTrafficCount : count);
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        super.register(info, leaseDuration, isReplication);
        this.handleRegistration(info, leaseDuration, isReplication);
    }

    public void register(InstanceInfo info, boolean isReplication) {
        super.register(info, isReplication);
        this.handleRegistration(info, this.resolveInstanceLeaseDuration(info), isReplication);
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        boolean cancelled = super.cancel(appName, serverId, isReplication);
        if (cancelled) {
            this.handleCancelation(appName, serverId, isReplication);
        }
        return cancelled;
    }

    public boolean renew(String appName, String serverId, boolean isReplication) {
        boolean renewed = super.renew(appName, serverId, isReplication);
        if (renewed) {
            this.handleRenewal(appName, serverId, isReplication);
        }
        return renewed;
    }

    protected boolean internalCancel(String appName, String id, boolean isReplication) {
        boolean cancelled = super.internalCancel(appName, id, isReplication);
        if (cancelled) {
            this.handleCancelation(appName, id, isReplication);
        }
        return cancelled;
    }

    private void handleCancelation(String appName, String id, boolean isReplication) {
        this.log("cancelled " + appName + ", serverId " + id + ", isReplication " + isReplication);
        this.publishEvent(new EurekaInstanceCanceledEvent((Object)this, appName, id, isReplication));
    }

    private void handleRegistration(InstanceInfo info, int leaseDuration, boolean isReplication) {
        this.log("registered " + info.getAppName() + ", vip " + info.getVIPAddress() + ", leaseDuration " + leaseDuration + ", isReplication " + isReplication);
        this.publishEvent(new EurekaInstanceRegisteredEvent((Object)this, info, leaseDuration, isReplication));
    }

    private void handleRenewal(String appName, String serverId, boolean isReplication) {
        InstanceInfo instanceInfo;
        this.log("renewed " + appName + ", serverId " + serverId + ", isReplication " + isReplication);
        Application application = this.getApplication(appName);
        if (application != null && (instanceInfo = application.getByInstanceId(serverId)) != null) {
            this.publishEvent(new EurekaInstanceRenewedEvent((Object)this, appName, serverId, instanceInfo, isReplication));
        }
    }

    private void log(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }

    private void publishEvent(ApplicationEvent applicationEvent) {
        this.ctxt.publishEvent(applicationEvent);
    }

    private int resolveInstanceLeaseDuration(InstanceInfo info) {
        int leaseDuration = 90;
        if (info.getLeaseInfo() != null && info.getLeaseInfo().getDurationInSecs() > 0) {
            leaseDuration = info.getLeaseInfo().getDurationInSecs();
        }
        return leaseDuration;
    }
}

