/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.jackson.mixin.ApplicationsJsonMixIn;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;
import com.netflix.discovery.converters.jackson.serializer.InstanceInfoJsonBeanSerializer;
import com.netflix.discovery.shared.Applications;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.springframework.cloud.configuration.SSLContextFactory;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;

final class EurekaHttpClientUtils {
    private EurekaHttpClientUtils() {
        throw new AssertionError((Object)"Must not instantiate constant utility class");
    }

    static MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(EurekaHttpClientUtils.objectMapper());
        return converter;
    }

    static ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        SimpleModule jsonModule = new SimpleModule();
        jsonModule.setSerializerModifier(EurekaHttpClientUtils.createJsonSerializerModifier());
        objectMapper.registerModule((Module)jsonModule);
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        objectMapper.addMixIn(Applications.class, ApplicationsJsonMixIn.class);
        objectMapper.addMixIn(InstanceInfo.class, InstanceInfoJsonMixIn.class);
        return objectMapper;
    }

    private static BeanSerializerModifier createJsonSerializerModifier() {
        return new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc.getBeanClass().isAssignableFrom(InstanceInfo.class)) {
                    return new InstanceInfoJsonBeanSerializer((BeanSerializerBase)serializer, false);
                }
                return serializer;
            }
        };
    }

    @Nullable
    static UserInfo extractUserInfo(String serviceUrl) {
        try {
            String[] credentials;
            URI serviceURI = new URI(serviceUrl);
            if (serviceURI.getUserInfo() != null && (credentials = serviceURI.getUserInfo().split(":")).length == 2) {
                return new UserInfo(credentials[0], credentials[1]);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    static Optional<SSLContext> context(TlsProperties properties) {
        if (properties == null || !properties.isEnabled()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new SSLContextFactory(properties).createSSLContext());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    record UserInfo(String username, String password) {
    }
}

