/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import java.util.Collections;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.RestClientTimeoutProperties;
import org.springframework.cloud.netflix.eureka.config.EurekaConfigServerInstanceProvider;
import org.springframework.cloud.netflix.eureka.config.HostnameBasedUrlRandomizer;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestClientTransportClientFactory;
import org.springframework.util.ClassUtils;

public class EurekaConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null)) {
            return;
        }
        registry.registerIfAbsent(EurekaClientConfigBean.class, context -> {
            if (!EurekaConfigServerBootstrapper.getDiscoveryEnabled(context).booleanValue()) {
                return null;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = EurekaConfigServerBootstrapper.getPropertyResolver(context);
            return (EurekaClientConfigBean)propertyResolver.resolveConfigurationProperties("eureka.client", EurekaClientConfigBean.class, EurekaClientConfigBean::new);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!EurekaConfigServerBootstrapper.getDiscoveryEnabled(context).booleanValue()) {
                return id -> Collections.emptyList();
            }
            EurekaClientConfigBean config = (EurekaClientConfigBean)context.get(EurekaClientConfigBean.class);
            EurekaHttpClient httpClient = new RestClientTransportClientFactory((TlsProperties)context.getOrElse(TlsProperties.class, null), (EurekaClientHttpRequestFactorySupplier)context.getOrElse(EurekaClientHttpRequestFactorySupplier.class, (Object)new DefaultEurekaClientHttpRequestFactorySupplier(new RestClientTimeoutProperties(), Collections.emptySet()))).newClient((EurekaEndpoint)HostnameBasedUrlRandomizer.randomEndpoint((EurekaClientConfig)config, EurekaConfigServerBootstrapper.getPropertyResolver(context)));
            return new EurekaConfigServerInstanceProvider(httpClient, config)::getInstances;
        });
    }

    private static ConfigServerConfigDataLocationResolver.PropertyResolver getPropertyResolver(BootstrapContext context) {
        return (ConfigServerConfigDataLocationResolver.PropertyResolver)context.getOrElseSupply(ConfigServerConfigDataLocationResolver.PropertyResolver.class, () -> new ConfigServerConfigDataLocationResolver.PropertyResolver((Binder)context.get(Binder.class), (BindHandler)context.getOrElse(BindHandler.class, null)));
    }

    public static Boolean getDiscoveryEnabled(BootstrapContext bootstrapContext) {
        ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = EurekaConfigServerBootstrapper.getPropertyResolver(bootstrapContext);
        return (Boolean)propertyResolver.get("spring.cloud.config.discovery.enabled", Boolean.class, (Object)false) != false && (Boolean)propertyResolver.get("eureka.client.enabled", Boolean.class, (Object)true) != false && (Boolean)propertyResolver.get("spring.cloud.discovery.enabled", Boolean.class, (Object)true) != false;
    }
}

