/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

public class RestClientEurekaHttpClient
implements EurekaHttpClient {
    private final RestClient restClient;

    public RestClientEurekaHttpClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        ResponseEntity response = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(builder -> builder.pathSegment(new String[]{"apps", info.getAppName()}).build(new Object[0]))).body((Object)info).header("Accept-Encoding", new String[]{"gzip"})).header("Content-Type", new String[]{"application/json"})).retrieve().toBodilessEntity();
        return RestClientEurekaHttpClient.eurekaHttpResponse(response);
    }

    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        ResponseEntity response = this.restClient.delete().uri(builder -> builder.pathSegment(new String[]{"apps", appName, id}).build(new Object[0])).retrieve().toBodilessEntity();
        return RestClientEurekaHttpClient.eurekaHttpResponse(response);
    }

    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        Function<UriBuilder, URI> uriFunction = builder -> builder.pathSegment(new String[]{"apps", appName, id}).queryParam("status", new Object[]{info.getStatus().toString()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).queryParamIfPresent("overriddenstatus", Optional.ofNullable(overriddenStatus).map(Enum::name)).build(new Object[0]);
        ResponseEntity response = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.put().uri(uriFunction)).header("Content-Type", new String[]{"application/json"})).header("Accept", new String[]{"application/json"})).retrieve().toEntity(InstanceInfo.class);
        EurekaHttpResponse.EurekaHttpResponseBuilder builder2 = EurekaHttpResponse.anEurekaHttpResponse((int)RestClientEurekaHttpClient.statusCodeValueOf(response), InstanceInfo.class).headers(RestClientEurekaHttpClient.headersOf(response));
        InstanceInfo entity = (InstanceInfo)response.getBody();
        if (entity != null) {
            builder2.entity((Object)entity);
        }
        return builder2.build();
    }

    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        Function<UriBuilder, URI> uriFunction = builder -> builder.pathSegment(new String[]{"apps", appName, id, "status"}).queryParam("value", new Object[]{newStatus.name()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).build(new Object[0]);
        ResponseEntity response = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.put().uri(uriFunction)).header("Content-Type", new String[]{"application/json"})).retrieve().toBodilessEntity();
        return RestClientEurekaHttpClient.eurekaHttpResponse(response);
    }

    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        Function<UriBuilder, URI> uriFunction = builder -> builder.pathSegment(new String[]{"apps", appName, id, "status"}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).build(new Object[0]);
        ResponseEntity response = this.restClient.delete().uri(uriFunction).header("Content-Type", new String[]{"application/json"}).retrieve().toBodilessEntity();
        return RestClientEurekaHttpClient.eurekaHttpResponse(response);
    }

    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("/apps/", regions);
    }

    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("/apps/delta", regions);
    }

    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("/vips/" + vipAddress, regions);
    }

    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("/svips/" + secureVipAddress, regions);
    }

    public EurekaHttpResponse<Application> getApplication(String appName) {
        ResponseEntity response = this.restClient.get().uri("/apps/" + appName, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().toEntity(Application.class);
        int statusCode = RestClientEurekaHttpClient.statusCodeValueOf(response);
        Application body = (Application)response.getBody();
        Application application = statusCode == HttpStatus.OK.value() && body != null ? body : null;
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, (Object)application).headers(RestClientEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("/apps/" + appName + "/" + id);
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("/instances/" + id);
    }

    public void shutdown() {
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        Function<UriBuilder, URI> uriFunction = builder -> builder.queryParamIfPresent("regions", Optional.ofNullable(regions).filter(it -> ((String[])it).length > 0).map(StringUtil::join)).build(new Object[0]);
        ResponseEntity response = this.restClient.get().uri(urlPath, uriFunction).header("Content-Type", new String[]{"application/json"}).header("Accept", new String[]{"application/json"}).retrieve().toEntity(Applications.class);
        int statusCode = RestClientEurekaHttpClient.statusCodeValueOf(response);
        Applications body = (Applications)response.getBody();
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, statusCode == HttpStatus.OK.value() && body != null ? body : null).headers(RestClientEurekaHttpClient.headersOf(response)).build();
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        ResponseEntity response = this.restClient.get().uri(urlPath, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().toEntity(InstanceInfo.class);
        int statusCode = RestClientEurekaHttpClient.statusCodeValueOf(response);
        InstanceInfo body = (InstanceInfo)response.getBody();
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, statusCode == HttpStatus.OK.value() && body != null ? body : null).headers(RestClientEurekaHttpClient.headersOf(response)).build();
    }

    private static Map<String, String> headersOf(ResponseEntity<?> response) {
        return response.getHeaders().toSingleValueMap();
    }

    private static int statusCodeValueOf(ResponseEntity<?> response) {
        return response.getStatusCode().value();
    }

    private static EurekaHttpResponse<Void> eurekaHttpResponse(ResponseEntity<?> response) {
        return EurekaHttpResponse.anEurekaHttpResponse((int)RestClientEurekaHttpClient.statusCodeValueOf(response)).headers(RestClientEurekaHttpClient.headersOf(response)).build();
    }
}

