/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.core.env.Environment;

public class LoadBalancerClientFactory
extends NamedContextFactory<LoadBalancerClientSpecification>
implements ReactiveLoadBalancer.Factory<ServiceInstance> {
    private static final Log log = LogFactory.getLog(LoadBalancerClientFactory.class);
    public static final String NAMESPACE = "loadbalancer";
    public static final String PROPERTY_NAME = "loadbalancer.client.name";
    private final LoadBalancerClientsProperties properties;

    @Deprecated
    public LoadBalancerClientFactory() {
        this(null);
    }

    public LoadBalancerClientFactory(LoadBalancerClientsProperties properties) {
        super(LoadBalancerClientConfiguration.class, NAMESPACE, PROPERTY_NAME);
        this.properties = properties;
    }

    public static String getName(Environment environment) {
        return environment.getProperty(PROPERTY_NAME);
    }

    public ReactiveLoadBalancer<ServiceInstance> getInstance(String serviceId) {
        return (ReactiveLoadBalancer)this.getInstance(serviceId, ReactorServiceInstanceLoadBalancer.class);
    }

    public LoadBalancerProperties getProperties(String serviceId) {
        if (this.properties == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"LoadBalancerClientsProperties is null. Please use the new constructor.");
            }
            return null;
        }
        if (serviceId == null || !this.properties.getClients().containsKey(serviceId)) {
            return this.properties;
        }
        return (LoadBalancerProperties)this.properties.getClients().get(serviceId);
    }
}

