/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.blocking.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestAdapter;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class BlockingLoadBalancerClient
implements LoadBalancerClient {
    private final LoadBalancerClientFactory loadBalancerClientFactory;
    private final LoadBalancerProperties properties;

    public BlockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory, LoadBalancerProperties properties) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        this.properties = properties;
    }

    public <T> T execute(String serviceId, LoadBalancerRequest<T> request) throws IOException {
        String hint = this.getHint(serviceId);
        LoadBalancerRequestAdapter lbRequest = new LoadBalancerRequestAdapter(request, (Object)new DefaultRequestContext(request, hint));
        Set<LoadBalancerLifecycle> supportedLifecycleProcessors = this.getSupportedLifecycleProcessors(serviceId);
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart((Request)lbRequest));
        ServiceInstance serviceInstance = this.choose(serviceId, (Request<T>)lbRequest);
        if (serviceInstance == null) {
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Request)lbRequest, (Response)new EmptyResponse())));
            throw new IllegalStateException("No instances available for " + serviceId);
        }
        return this.execute(serviceId, serviceInstance, (LoadBalancerRequest<T>)lbRequest);
    }

    public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
        DefaultResponse defaultResponse = new DefaultResponse(serviceInstance);
        Set<LoadBalancerLifecycle> supportedLifecycleProcessors = this.getSupportedLifecycleProcessors(serviceId);
        Request lbRequest = request instanceof Request ? (Request)request : new DefaultRequest();
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStartRequest(lbRequest, (Response)new DefaultResponse(serviceInstance)));
        try {
            Object response = request.apply(serviceInstance);
            Object clientResponse = this.getClientResponse(response);
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, lbRequest, (Response)defaultResponse, clientResponse)));
            return (T)response;
        }
        catch (IOException iOException) {
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)iOException, lbRequest, (Response)defaultResponse)));
            throw iOException;
        }
        catch (Exception exception) {
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)exception, lbRequest, (Response)defaultResponse)));
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
            return null;
        }
    }

    private <T> Object getClientResponse(T response) {
        ClientHttpResponse clientHttpResponse = null;
        if (response instanceof ClientHttpResponse) {
            clientHttpResponse = (ClientHttpResponse)response;
        }
        if (clientHttpResponse != null) {
            try {
                return new ResponseData(clientHttpResponse, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return response;
    }

    private Set<LoadBalancerLifecycle> getSupportedLifecycleProcessors(String serviceId) {
        return LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.loadBalancerClientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), DefaultRequestContext.class, Object.class, ServiceInstance.class);
    }

    public URI reconstructURI(ServiceInstance serviceInstance, URI original) {
        return LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
    }

    public ServiceInstance choose(String serviceId) {
        return this.choose(serviceId, ReactiveLoadBalancer.REQUEST);
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerClientFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return null;
        }
        Response loadBalancerResponse = (Response)Mono.from((Publisher)loadBalancer.choose(request)).block();
        if (loadBalancerResponse == null) {
            return null;
        }
        return (ServiceInstance)loadBalancerResponse.getServer();
    }

    private String getHint(String serviceId) {
        String defaultHint = this.properties.getHint().getOrDefault("default", "default");
        String hintPropertyValue = (String)this.properties.getHint().get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }
}

