/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class RequestBasedStickySessionServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private static final Log LOG = LogFactory.getLog(RequestBasedStickySessionServiceInstanceListSupplier.class);
    private final LoadBalancerProperties properties;

    public RequestBasedStickySessionServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerProperties properties) {
        super(delegate);
        this.properties = properties;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return (Flux)this.delegate.get();
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        String instanceIdCookieName = this.properties.getStickySession().getInstanceIdCookieName();
        Object context = request.getContext();
        if (context instanceof RequestDataContext) {
            MultiValueMap cookies = ((RequestDataContext)context).getClientRequest().getCookies();
            if (cookies == null) {
                return this.get();
            }
            String cookie = (String)cookies.getFirst((Object)instanceIdCookieName);
            if (cookie != null) {
                return this.get().map(serviceInstances -> this.selectInstance((List<ServiceInstance>)serviceInstances, cookie));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cookie not found. Returning all instances returned by delegate.");
            }
            return this.get();
        }
        return this.get();
    }

    private List<ServiceInstance> selectInstance(List<ServiceInstance> serviceInstances, String cookie) {
        for (ServiceInstance serviceInstance : serviceInstances) {
            if (!cookie.equals(serviceInstance.getInstanceId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Returning the service instance: %s. Found for cookie: %s", serviceInstance.toString(), cookie));
            }
            return Collections.singletonList(serviceInstance);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Service instance for cookie: %s not found. Returning all instances returned by delegate.", cookie));
        }
        return serviceInstances;
    }
}

